<?php
namespace Ev3Crud\Action;

use Crud\Traits\FindMethodTrait;
use Crud\Traits\RedirectTrait;
use Crud\Traits\SaveMethodTrait;
use Crud\Traits\ViewVarTrait;

class SortAction extends \Crud\Action\BaseAction
{
    use FindMethodTrait;
    use RedirectTrait;
    use SaveMethodTrait;
    use ViewVarTrait;

    /**
     * Default settings for 'sort' actions
     *
     * @var array
     */
    protected $_defaultConfig = [
        'enabled' => true,
        'scope' => 'table',
        'findMethod' => 'threaded',
        'view' => null,
        'viewVar' => null,
        'saveOptions' => [],
        'serialize' => [],
        'messages' => [
            'success' => [
                'text' => 'Successfully updated {name}'
            ],
            'error' => [
                'text' => 'Could not update {name}'
            ]
        ]
    ];

    /**
     * HTTP GET handler
     *
     * @return void
     * @throws \Cake\Network\Exception\NotFoundException If record not found
     */
    protected function _get()
    {
        $repository = $this->_table();

        $query = $repository->find($this->findMethod());
        // Order by the `lft` column of the table, we need to alias this as it may be ambiguous
        // otherwise (for example on tables with a `parent_id`).
        $query->order([$this->_table()->alias() . '.lft' => 'ASC']);

        $subject = $this->_subject(['success' => true, 'query' => $query]);

        $this->_trigger('beforeFind', $subject);
        $subject->set(['entities' => $subject->query]);
        $this->_trigger('afterFind', $subject);

        $this->_trigger('beforeRender', $subject);
    }

    /**
     * HTTP POST handler
     *
     * @return void|\Cake\Network\Response
     */
    protected function _post()
    {
        return $this->_put();
    }

    /**
     * HTTP PUT handler
     *
     * @return void|\Cake\Network\Response
     */
    protected function _put()
    {
        $subject = $this->_subject();
        $entities = $this->_table()->patchEntities(
            $this->_table()->find('all'),
            $this->_request()->data['sort'],
            $this->saveOptions()
        );
        $this->_trigger('beforeSort', $subject);
        if ($this->_table()->saveMany($entities)) {
            return $this->_success($subject);
        }

        return $this->_error($subject);
    }

    /**
     * Success callback
     *
     * @param \Crud\Event\Subject $subject Event subject
     * @return \Cake\Network\Response
     */
    protected function _success(\Crud\Event\Subject $subject)
    {
        $subject->set(['success' => true, 'created' => false]);
        $this->_trigger('afterSort', $subject);

        $this->setFlash('success', $subject);

        return $this->_redirect($subject, ['action' => 'index']);
    }

    /**
     * Error callback
     *
     * @param \Crud\Event\Subject $subject Event subject
     * @return void
     */
    protected function _error(\Crud\Event\Subject $subject)
    {
        $subject->set(['success' => false, 'created' => false]);
        $this->_trigger('afterSort', $subject);

        $this->setFlash('error', $subject);

        return $this->_redirect($subject, ['action' => 'index']);
    }
}
