<?php
namespace Ev3Crud\Action;

use Crud\Traits\ViewVarTrait;

/**
 * Handles 'Delete' Crud actions
 *
 * This is an extended version of the Crud delete action so that we can handle soft deletes.
 */
class DeleteAction extends \Crud\Action\DeleteAction
{

    use ViewVarTrait;

    /**
     * HTTP GET handler
     *
     * @param string $id Record id
     * @return void
     * @throws \Cake\Network\Exception\NotFoundException If record not found
     */
    protected function _get($id = null)
    {
        $subject = $this->_subject();
        $subject->set(['id' => $id]);
        $subject->set(['entity' => $this->_findRecord($id, $subject)]);

        $this->_trigger('beforeRender', $subject);
    }

    /**
     * HTTP POST handler
     *
     * @param string $id Record id
     * @return \Cake\Network\Response
     */
    protected function _post($id = null)
    {
        $subject = $this->_subject();
        $subject->set(['id' => $id]);

        $entity = $this->_findRecord($id, $subject);

        $event = $this->_trigger('beforeDelete', $subject);
        if ($event->isStopped()) {
            return $this->_stopped($subject);
        }

        if ($this->_table()->hasField('is_removed')) {
            // We want to soft delete this entity.
            $entity->is_removed = true;
            if ($this->_table()->save($entity)) {
                $this->_success($subject);
            } else {
                $this->_error($subject);
            }
        } else {
            // Proceed with the deletion of the record.
            if ($this->_table()->delete($entity)) {
                $this->_success($subject);
            } else {
                $this->_error($subject);
            }
        }

        return $this->_redirect($subject, ['action' => 'index']);
    }

    /**
     * HTTP PUT handler
     *
     * Thin proxy for _post
     *
     * @param mixed $id Record id
     * @return void|\Cake\Network\Response
     */
    protected function _put($id = null)
    {
        return $this->_post($id);
    }
}
