<?php $this->assign('title', $title) ?>

<div class="<?= $this->Cms->getCssClasses(); ?>">

    <?= $this->element('Ev3Cms.action-header') ?>

    <div class="row">
        <div class="col-xs-12">
            <div class="card">
                <div class="card-header">
                    <i class="fa fa-sort-amount-asc" aria-hidden="true"></i> <?= __d('core_u_i', 'Sort {0}', [$pluralHumanName]) ?>
                </div>
                <div class="card-block">
                    <ol class="js-sortable sortable" data-depth="2">
                        <?= $this->element('CoreUI.sort/list', ['entities' => $$viewVar]) ?>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <?= $this->Form->create(null, ['role' => 'form', 'url' => $formUrl]); ?>

    <?php // We include some hidden text inputs that the JS will populate to update the tree on save to avoid security blackhole. ?>
    <div style="display: none;"><?= $this->element('CoreUI.sort/fields', ['entities' => $$viewVar]) ?></div>

    <div class="col pull-right buffer-s">
        <?= $this->Form->button($saveButton, ['class' => 'btn btn-primary js-sortable-save', 'name' => '_save']) ?>

        <?php
            if (!in_array('back', $extraButtonsBlacklist)) {
                echo $this->Html->link(__d('ev3_cms', 'Back'), ['action' => 'index'], ['class' => 'btn btn-default', 'role' => 'button', 'value' => true]);
            }
        ?>
    </div>

    <?= $this->Form->end() ?>

</div>
