<?php $this->assign('title', $title) ?>
<?= $this->fetch('before_index'); ?>

<div class="<?= $this->Cms->getCssClasses(); ?>">

    <?= $this->element('Ev3Cms.action-header') ?>

    <?= $this->fetch('search'); ?>

    <?= $this->element('Ev3Cms.index/bulk_actions/form_start', compact('bulkActions')); ?>

    <div class="row">
        <div class="col-xs-12">
            <div class="card">
                <div class="card-header">
                    <i class="fa fa-align-justify"></i> <?= $title ?>
                </div>
                <div class="card-block table-responsive">
                    <table class="table table-hover table-condensed">
                        <thead>
                            <tr>
                                <?= $this->element('Ev3Cms.index/bulk_actions/table', compact('bulkActions', 'primaryKey', 'singularVar')); ?>

                                <?php
                                foreach ($fields as $field => $options) :
                                    ?>
                                    <th>
                                        <?php
                                        if (!empty($options['disableSort'])) {
                                            echo isset($options['title']) ? $options['title'] : \Cake\Utility\Inflector::humanize($field);
                                        } else {
                                            echo $this->Paginator->sort($field, isset($options['title']) ? $options['title'] : null, $options);
                                        }
                                        ?>
                                    </th>
                                    <?php
                                endforeach;
                                ?>
                                <?php if ($actionsExist = !empty($actions['entity'])): ?>
                                    <th><?= __d('ev3_cms', 'Actions'); ?></th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach (${$viewVar} as $singularVar): ?>
                                <tr>
                                    <?= $this->element('Ev3Cms.index/bulk_actions/record', compact('bulkActions', 'primaryKey', 'singularVar')); ?>
                                    <?= $this->element('Ev3Cms.index/table_columns', compact('singularVar')); ?>

                                    <?php if ($actionsExist): ?>
                                        <td class="actions"><?= $this->element('actions', [
                                            'singularVar' => $singularVar,
                                            'actions' => $actions['entity']
                                        ]); ?></td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                    <?= $this->element('Ev3Cms.index/bulk_actions/form_end', compact('bulkActions')); ?>
                    <?= $this->element('Ev3Cms.index/pagination'); ?>
                </div>
            </div>
        </div>
    </div>

</div>

<?= $this->fetch('after_index'); ?>
