<?php $this->assign('title', $title) ?>
<?= $this->fetch('before_form'); ?>

<div class="<?= $this->Cms->getCssClasses(); ?>">
    <?= $this->element('Ev3Cms.action-header') ?>

    <?= $this->Form->create(${$viewVar}, ['role' => 'form', 'url' => $formUrl, 'data-dirty-check' => $enableDirtyCheck]); ?>
    <?= $this->Cms->redirectUrl(); ?>
    <div class="row">
        <div class="col-lg-<?= $this->exists('form.sidebar') ? '8' : '12' ?>">
            <?= $this->Form->input($primaryKey) ?>
            <p><?= __d('ev3_cms', 'You are about to delete "{0}".', ${$viewVar}->$displayField) ?></p>
            <p class="alert alert-danger"><strong><?= __d('ev3_cms', 'WARNING: This change cannot be undone! Any content will be permanently deleted.') ?></strong></p>
        </div>

        <?php if ($this->exists('form.sidebar')) : ?>
            <div class="col-lg-2">
                <?= $this->fetch('form.sidebar'); ?>
            </div>
        <?php endif; ?>
    </div>
    <div class="row">
        <div class="col-lg-<?= $this->exists('form.sidebar') ? '8' : '12' ?>">
           <div class="form-group">
                <div class="col pull-right">
                    <?= $this->Form->button(__d('ev3_crud', 'Delete'), ['class' => 'btn btn-success btn-save-continue', 'name' => '_edit', 'value' => true]) ?>
                    <?= $this->Html->link(__d('ev3_crud', 'Cancel'), ['action' => 'index'], ['class' => 'btn btn-default', 'role' => 'button', 'value' => true]) ?>
                </div>
            </div>
        </div>
    </div>
    <?= $this->Form->end(); ?>
</div>

<?= $this->fetch('after_form'); ?>
