<!--
 * CoreUI - Open Source Bootstrap Admin Template
 * @version v1.0.0-alpha.2
 * @link http://coreui.io
 * Copyright (c) 2016 creativeLabs Łukasz Holeczek
 * @license MIT
 -->
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->

    <title><?= $this->fetch('title') ?></title>

    <!-- Icons -->
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">

    <!-- Main styles for this application -->
    <?= $this->Html->css('styles') ?>

</head>

<!-- BODY options, add following classes to body to change options
        1. 'compact-nav'          - Switch sidebar to minified version (width 50px)
        2. 'sidebar-nav'          - Navigation on the left
            2.1. 'sidebar-off-canvas'   - Off-Canvas
                2.1.1 'sidebar-off-canvas-push' - Off-Canvas which move content
                2.1.2 'sidebar-off-canvas-with-shadow'  - Add shadow to body elements
        3. 'fixed-nav'            - Fixed navigation
        4. 'navbar-fixed'         - Fixed navbar
        5. 'footer-fixed'         - Fixed navbar
    -->

<body class="navbar-fixed sidebar-nav fixed-nav">
    <header class="navbar">
        <div class="container-fluid">
            <button class="navbar-toggler mobile-toggler hidden-lg-up" type="button">☰</button>
            <a class="navbar-brand" href="#"></a>
            <ul class="nav navbar-nav hidden-md-down">
                <li class="nav-item">
                    <a class="nav-link navbar-toggler layout-toggler" href="#">☰</a>
                </li>
                <li class="nav-item px-1">
                    <?= $this->Html->link('Settings', ['controller' => 'settings', 'plugin' => 'Ev3Settings'], ['class' => 'nav-link']) ?>
                </li>
                <li class="nav-item px-1">
                    <?= $this->Html->link('Users', ['controller' => 'users', 'plugin' => 'Ev3Users'], ['class' => 'nav-link']) ?>
                </li>
            </ul>
            <ul class="nav navbar-nav float-xs-right hidden-md-down">
                <li class="nav-item px-1">
                    <?= $this->Html->link('View Site', '/', ['class' => 'nav-link', 'target' => '_blank']) ?>
                </li>
                <li class="nav-item px-1 dropdown">
                    <a class="nav-link dropdown-toggle nav-link" data-toggle="dropdown" href="#" role="button" aria-haspopup="true" aria-expanded="false">
                        <i class="fa fa-user fa-2x"></i>
                        <span class="hidden-md-down"><?= h($authUser['first_name']) ?></span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right">
                        <div class="dropdown-header text-xs-center">
                            <strong>Account</strong>
                        </div>
                        <?= $this->Html->link('<i class="fa fa-cogs"></i> Edit Account', ['controller' => 'users', 'action' => 'profile', 'plugin' => 'Ev3Users'], ['escape' => false, 'class' => 'dropdown-item']) ?>
                        <?= $this->Html->link('<i class="fa fa-key"></i> Change Password', ['controller' => 'users', 'action' => 'change_password', 'plugin' => 'Ev3Users'], ['escape' => false, 'class' => 'dropdown-item']) ?>
                    </div>
                </li>
                <li class="nav-item px-1">
                    <?= $this->Html->link('<i class="fa fa-sign-out" aria-hidden="true"></i> ' . __d('CoreUI', 'Logout'), ['controller' => 'auth', 'action' => 'logout', 'plugin' => 'Ev3Users'], ['class' => 'nav-link', 'escape' => false]) ?>
                </li>
            </ul>
        </div>
    </header>

    <div class="sidebar">

        <nav class="sidebar-nav">
            <?= $this->cell('Ev3Cms.CmsMenu') ?>
        </nav>
    </div>

    <!-- Main content -->
    <main class="main">

        <?= $this->element('breadcrumb') ?>
        <div class="container-fluid">
            <div class="animated fadeIn">
                <?= $this->Flash->render() ?>
                <?= $this->fetch('content') ?>
            </div>
        </div>
        <!-- /.conainer-fluid -->
    </main>


    <footer class="footer">
        <span class="text-left">
            <b>For assistance contact:</b> <a href="http://www.evoluted.net" target="_blank">Evoluted New Media</a> | <b>Tel:</b> <a href="tel:01142729753">0114 272 9753</a> | <b>Email:</b> <a href="mailto:info@evoluted.net">info@evoluted.net</a>
        </span>
    </footer>

    <?= $this->fetch('modal') ?>

    <!-- Plugins and scripts -->
    <?= $this->Html->script('https://cdn.tinymce.com/4.4/tinymce.min.js') ?>
    <?= $this->Html->script('admin.min') ?>

</body>

</html>
