$(document).ready(function() {
    // Make a sortable list and disable text selection on the items in it.
    $('.js-sortable').nestedSortable({
        handle: 'div',
        items: 'li',
        tolerance: 'pointer',
        toleranceElement: '> div',
        isTree: true,
        maxLevels: $(this).data('depth'),
        excludeRoot: true
    }).disableSelection();
    // On save of a sorted list we need to populate the sort list's form ready for updating the
    // database.
    $(document).on('click submit', '.js-sortable-save', function (e) {
        e.preventDefault();
        var $form = $(this).closest('form');
        var entities = $('.js-sortable').nestedSortable('toArray', {startDepthCount: 0});
        $(entities).each(function(key, entity){
            // Make sure we're consistent with unset parent_id's.
            if (entity.parent_id === 'none' || !entity.parent_id) {
                // This needs to be set as empty (not '0') to ensure Cake saves this as `null`.
                entity.parent_id = '';
            }

            if (entity.id) {
                // Determine the correct lft and rght values.
                var lft = parseInt(entity.left);
                var rght = parseInt(entity.right);
                // Update the form values.
                $('#sort-' + entity.id + '-id').val(entity.id);
                $('#sort-' + entity.id + '-parent-id').val(entity.parent_id);
                $('#sort-' + entity.id + '-lft').val(lft);
                $('#sort-' + entity.id + '-rght').val(rght);
            }
        });
        $form.submit();
    });
});
