$(document).ready(function() {
    $('.js-ev3-assets-group').each(function() {
        toggleAssetButton($(this).data('type'));
    });

    // Load iframe in modal
    $('#modal-image-library').on('shown.bs.modal', function() {
        $(this).find('iframe').attr('src', '/library/ev3-assets/images/index');
    });

    // Trigger modal
    $(document).on('click', '.js-iframe-modal', function(e) {
        e.preventDefault();
        // Show the modal and attach the asset type so that we can maintain context.
        var type = $(this).closest('.js-ev3-assets-group').attr('data-type');
        $('#modal-image-library').modal('show').attr('data-type', type);
    });

    // Remove asset
    $(document).on('click', '.js-ev3-assets-remove', function(e) {
        e.preventDefault();
        var type = $(this).closest('.js-ev3-assets-group').data('type');
        $(this).closest('.js-ev3-assets-asset').remove();
        toggleAssetButton(type);
    });
});

/**
 * Method called from the assets library when adding an image.
 */
function addImageAssetPreview(imageId) {
    var $modal = $('#modal-image-library');
    $modal.modal('hide');
    var type = $modal.attr('data-type');
    var $assetsGroup = $('.js-ev3-assets-group[data-type="' + type +'"');
    var key = parseInt($assetsGroup.attr('data-key'));
    $('.js-image-asset-previews').attr('data-key', parseInt(key) + 1);

    $.ajax({
        url: '/admin/ev3-assets/images/preview/' + imageId + '/' + type + '/' + key
    }).done(function(html){
        $('.js-image-asset-previews', $assetsGroup).append(html);
        $assetsGroup.attr('data-key', key + 1);
        toggleAssetButton(type);
    });

    return;
}

function toggleAssetButton(type) {
    var $assetsGroup = $('.js-ev3-assets-group[data-type="' + type +'"');
    var $btn = $('.js-iframe-modal', $assetsGroup);
    var slots = $assetsGroup.data('slots');
    if (slots < 0) {
        // We've got unlimited assets slots so don't need to toggle the button.
        return;
    }
    // Count the current number of assets.
    var assets = $('.js-ev3-assets-asset', $assetsGroup).length;
    if (assets >= slots) {
        $btn.prop('disabled', true);
    } else {
        $btn.prop('disabled', false);
    }
}
