<?php
namespace Ev3Cms\Listener;

use Cake\Event\EventListenerInterface;

class UserListener implements EventListenerInterface
{
    public function implementedEvents()
    {
        return [
            'Users.Component.UsersAuth.afterLogin' => 'loginRedirect',
            'Users.Component.UsersAuth.afterLogout' => 'logoutRedirect',
        ];
    }

    /**
     * Login redirect
     * @param \Cake\Event\Event $event Event.
     * @return array Redirect route
     */
    public function loginRedirect($event)
    {
        return ['plugin' => 'Ev3Cms', 'controller' => 'Dashboard', 'action' => 'index'];
    }

    /**
     * Logout redirect
     * @param \Cake\Event\Event $event Event.
     * @return array Redirect route
     */
    public function logoutRedirect($event)
    {
        return ['plugin' => 'Ev3Users', 'controller' => 'Auth', 'action' => 'login'];
    }
}
