<?php
namespace Ev3Cms\Controller;

use Cake\Controller\Controller as BaseController;

class AppController extends BaseController
{
    use \Crud\Controller\ControllerTrait;

    /**
     * Initialization hook method.
     *
     * Use this method to add common initialization code like loading components.
     *
     * e.g. `$this->loadComponent('Security');`
     *
     * @return void
     */
    public function initialize()
    {
        parent::initialize();
        // RequestHandler must be loaded before we load the Crud component.
        $this->loadComponent('RequestHandler');
        $this->loadComponent('Security');
        $this->loadComponent('Flash');
        $this->loadComponent('Ev3Breadcrumb.Breadcrumb', [
            'crumbs' => [
                [
                    'text' => __d('ev3_cms', 'Dashboard'),
                    'url' => '/admin'
                ]
            ]
        ]);
        $this->loadComponent('CakeDC/Users.UsersAuth');
        // Load Crud with the API listeners. We will map the actions in the beforeFilter of each
        // controller to fine tune things (not all controllers want the same actions).
        $this->loadComponent('Crud.Crud', [
            'listeners' => [
                'Ev3Cms.View',
                'Crud.Redirect',
                'Ev3Assets.Assets'
            ]
        ]);

        $this->viewClass = 'Ev3Cms\View\CmsView';
    }

    /**
     * Before filter callback.
     *
     * @param  \Cake\Event\Event $event Event
     * @return void
     */
    public function beforeFilter(\Cake\Event\Event $event)
    {
        parent::beforeFilter($event);
        $this->set('authUser', $this->Auth->user());
        if (in_array($this->request->action, ['add', 'edit'])) {
            $this->_form();
        }
    }

    /**
     * Before render callback
     *
     * @param \Cake\Event\Event $event Event
     * @return void
     */
    public function beforeRender(\Cake\Event\Event $event)
    {
        parent::beforeRender($event);
        $this->viewBuilder()->theme('CoreUI');
    }

    /**
     * Extend this method in your controllers to share logic between the add and edit actions.
     *
     * @return void
     */
    protected function _form()
    {
        return;
    }
}
