Ev3Cms
======

This plugin handles the CMS/admin area of the application and is based on the [Crud View](https://github.com/FriendsOfCake/crud-view) plugin by [Friends of Cake](https://github.com/FriendsOfCake).

This plugin handles the scaffolding of admin pages, theming is handled separately.

Installation
------------

Install using Composer:

```
composer require ev3/cms
```

Reserved Field Names
--------------------

The following field names have special meanings in the CMS and are therefore reserved for these uses:-

 - `is_protected` - flags items that cannot be removed
 - `lft` and `rght` - used by the tree behavior
 - `is_removed` - flags soft deleted items
 - `redirect` - used to define a redirect URL for redirecting when an entity is viewed directly
 - `redirect_url` - this is used by Crud to redirect forms on save

Bake
----

You can bake admin controllers to auto-generate the skeleton code for a controller like this:-

```
bin/cake bake controller [controller_name] --theme Ev3Cms --prefix Admin
```

For example, to create a `BookingsController`:-

```
bin/cake bake controller bookings --theme Ev3Cms --prefix Admin
```
