<?php
namespace Ev3CmsForm\View\Widget;

use Cake\View\Form\ContextInterface;

/**
 * Input widget class for generating a display only fields.
 */
class DisplayWidget extends \BootstrapUI\View\Widget\BasicWidget
{

    /**
     * Render a display only form widget.
     *
     * Data supports the following keys:
     *
     * - `name` - Set the input name.
     * - `val` - A string of the option to mark as selected.
     * - `escape` - Set to false to disable HTML escaping.
     *
     * All other keys will be converted into HTML attributes.
     *
     * @param array $data The data to build a textarea with.
     * @param \Cake\View\Form\ContextInterface $context The current form context.
     * @return string HTML elements.
     */
    public function render(array $data, ContextInterface $context)
    {
        // We need to define a new template for the display.
        $this->_templates->add([
            'display' => '<div{{attrs}}>{{val}}</div>'
        ]);
        return $this->_templates->format('display', $data);
    }
}
