<?php
namespace Ev3CmsForm\View\Widget;

use Cake\View\Form\ContextInterface;

/**
 * Input widget class for generating a display only datetime.
 */
//class DisplayDatetimeWidget extends \BootstrapUI\View\Widget\BasicWidget
class DisplaySelectWidget extends DisplayWidget
{

    /**
     * Render a display only datetime form widget.
     *
     * Data supports the following keys:
     *
     * - `name` - Set the input name.
     * - `val` - A string of the option to mark as selected.
     * - `escape` - Set to false to disable HTML escaping.
     *
     * All other keys will be converted into HTML attributes.
     *
     * @param array $data The data to build a textarea with.
     * @param \Cake\View\Form\ContextInterface $context The current form context.
     * @return string HTML elements.
     */
    public function render(array $data, ContextInterface $context)
    {
        $options = $data['options']->toArray();
        $optionValues = array_keys($options);
        $values = [];
        foreach ((array)$data['val'] as $option) {
            if (in_array($option, $optionValues)) {
                $values[] = $options[$option];
            }
        }
        $data['val'] = implode(', ', $values);
        return parent::render($data, $context);
    }
}
