<?php
namespace Ev3CmsForm\View\Helper;

use Cake\View\View;

class FormHelper extends \BootstrapUI\View\Helper\FormHelper
{

    /**
     * Default display widgets. This maps the display types to the relevant widget.
     *
     * @var array
     */
    protected $_displayWidgets = [
        'displaySelect' => 'Ev3CmsForm\View\Widget\DisplaySelectWidget',
        'display' => 'Ev3CmsForm\View\Widget\DisplayWidget'
    ];

    protected $_displayWidgetsWithOptions = [
        'displaySelect'
    ];

    /**
     * Construct the display widgets.
     *
     * @param \Cake\View\View $View The View this helper is being attached to.
     * @param array $config Configuration settings for the helper.
     */
    public function __construct(View $View, array $config = [])
    {
        parent::__construct($View, $config);
        foreach ($this->_displayWidgets as $displayType => $displayWidget) {
            $this->addWidget($displayType, $displayWidget);
        }
    }

    /**
     * Creates a WYSIWYG textarea widget.
     *
     * ### Options:
     *
     * - `data-config` - Determines the editor config as defined in the JS for handling the editor
     *
     * @param string $fieldName Name of a field, in the form "modelname.fieldname"
     * @param array $options Array of HTML attributes, and special options above.
     * @return string A generated HTML text input element
     * @link http://book.cakephp.org/3.0/en/views/helpers/form.html#creating-textareas
     */
    public function wysiwyg($fieldName, array $attributes = [])
    {
        $attributes = $this->_initInputField($fieldName, $attributes);
        unset($attributes['type']);
        $attributes['data-config'] = !empty($attributes['data-config']) ? $attributes['data-config'] : 'lite';
        return $this->widget('textarea', $attributes);
    }

    /**
     * Missing method handler - implements various simple input types. Is used to create inputs
     * of various types. e.g. `$this->Form->text();` will create `<input type="text" />` while
     * `$this->Form->range();` will create `<input type="range" />`
     *
     * This is extended here to allow us to make sure any display widgets that require options are
     * initiated correctly and to implement various display types not defined in the `displayWidgets`
     * property of the helper.
     *
     * @param string $method Method name / input type to make.
     * @param array $params Parameters for the method call
     * @return string Formatted input method.
     * @throws \Cake\Core\Exception\Exception When there are no params for the method call.
     */
    public function __call($method, $params)
    {
        if (in_array($method, $this->_displayWidgetsWithOptions)) {
            // We need to load the options for the 'select' type so that we can correctly display
            // this field as display only content.
            $params[1]['type'] = 'select';
            $params[1] = $this->_magicOptions($params[0], $params[1], true);
            $params[1]['type'] = $method;
            // Ensure we exclude the display field from the security hash.
            $this->unlockField($params[1]['name']);
        } elseif (strpos($method, 'display') === 0) {
            // Fallback for display types not explicitly defined with a widget.
            if (isset($params[1])) {
                $attributes = $params[1];
            }
            $attributes['type'] = 'display';
            $attributes = $this->_initInputField($params[0], $attributes);
            // Ensure we exclude the display field from the security hash.
            $this->unlockField($attributes['name']);
            return $this->widget($attributes['type'], $attributes);
        }
        return parent::__call($method, $params);
    }
}
