<?php
namespace Ev3Breadcrumb\View\Helper;

use Cake\View\Helper;

class BreadcrumbHelper extends Helper
{

    public $helpers = ['Html'];

    public $_defaultConfig = [
        'crumbsWrapTag' => null,
        'crumbsWrapAttributes' => [],
        'crumbWrapTag' => 'li',
        'crumbWrapAttributes' => [],
        'separator' => '<span class="breadcrumbs__sep"><i class="fa fa-angle-right"></i></span>'
    ];

    /**
     * Returns the back link if set.
     * @param  array $breadcrumbs Full breadcrumbs variable set by the plugin
     * @return string|void        Back link
     */
    public function backLink($breadcrumbs)
    {
        if (!empty($breadcrumbs['backLink']['text']) && !empty($breadcrumbs['backLink']['url'])) {
            return $this->Html->link(
                $breadcrumbs['backLink']['text'],
                $breadcrumbs['backLink']['url'],
                !empty($breadcrumbs['backLink']['options']) ? $breadcrumbs['backLink']['options'] : []
            );
        }

        return;
    }

    /**
     * Returns the breadcrumb.
     * @param  array $breadcrumbs Full breadcrumbs variable set by the plugin
     * @return string|void        Fully marked up breadcrumb
     */
    public function crumbs($breadcrumbs)
    {
        $crumbs = [];
        foreach ($breadcrumbs['crumbs'] as $crumb) {
            $crumbs[] = $this->Html->tag(
                $this->_config['crumbWrapTag'],
                $this->crumb($crumb),
                $this->_config['crumbWrapAttributes']
            );
        }
        if (!empty($this->_config['crumbsWrapTag'])) {
            return $this->Html->tag(
                $this->_config['crumbsWrapTag'],
                implode($this->separator(), $crumbs),
                $this->_config['crumbsWrapAttributes']
            );
        } else {
            return implode($this->separator(), $crumbs);
        }
    }

    /**
     * Returns a breadcrumb.
     * @param  array $breadcrumbs Breadcrumb array
     * @return string|void
     */
    public function crumb($crumb)
    {
        if (!empty($crumb['url'])) {
            return $this->Html->link(
                $crumb['text'],
                $crumb['url'],
                !empty($crumb['options']) ? $crumb['options'] : []
            );
        } else {
            return $crumb['text'];
        }
    }

    /**
     * Returns the separator.
     * @return string Separator
     */
    public function separator()
    {
        return $this->_config['separator'];
    }

}
