<?php
namespace Ev3Breadcrumb\Controller\Component;

use Cake\Controller\Component;
use Cake\Event\Event;

class BreadcrumbComponent extends Component
{
    /**
     * array containing the crumbs we've added
     *
     * @var array
     */
    public $crumbs = [
        [
            'text' => 'Home',
            'url' => '/'
        ]
    ];

    /**
     * array containing the text / link for a floating right item (usually back link)(
     *
     * @var array
     */
    public $backLink = [];

    /**
     * auto add a back link if none is added
     *
     * @var bool
     */
    public $autoBackLink = true;

    /**
     * back link prefix text for auto generated back links
     *
     * @var string
     */
    public $backLinkPrefix = 'Back to ';

    public function initialize(array $config)
    {
        if (isset($config['crumbs'])) {
            $this->crumbs = $config['crumbs'];
        }
    }

    /**
     * add a breadcrumb
     *
     * @param string $string The crumb text to display
     * @param array|string|null $url Optional: The actual link or route array.
     * @param array $options Optional: Link options, incase escape => false type info needs passing
     * @return void
     */
    public function addCrumb($text = null, $url = null, $options = [])
    {
        $this->crumbs[] = [
            'text' => $text,
            'url' => $url,
            'options' => $options
        ];

        return;
    }

    /**
     * Return the main breadcrumb crumbs
     *
     * @return array Items will be returned
     */
    public function crumbs()
    {
        return $this->crumbs;
    }

    /**
     * Clear all the crumbs.
     * Just sets back to empty array
     */
    public function clearCrumbs()
    {
        $this->crumbs = [];
    }

    /**
     * add or return the back link
     *
     * @param string|null $text Optional: The link text to display
     * @param array|string|null $url Optional: The actual link or route array.
     * @param array $options Optional: Link options, incase escape => false type info needs passing
     * @return array If both items are null, items will be returned
     */
    public function backLink($text = null, $url = null, $options = [])
    {
        if (is_null($text)) {
            return $this->backLink;
        }

        $this->backLink = [
            'text' => $text,
            'url' => $url,
            'options' => $options
        ];
    }

    /**
     * Before Render callback. If we've not got the controller yet
     * set it's object and then assign all our vars to template
     *
     * Called before the Controller::beforeRender(), and before
     * the view class is loaded, and before Controller::render()
     *
     * @param \Cake\Event\Event $event The Controller.beforeRender event.
     * @return void
     */
    public function beforeRender(Event $event)
    {
        if (is_null($this->_controller)) {
            $this->_controller = $event->subject();
        }

        if ($this->autoBackLink === true && empty($this->backLink)) {
            end($this->crumbs);
            $this->backLink = prev($this->crumbs);
            $this->backLink['text'] = $this->backLinkPrefix . $this->backLink['text'];
        }

        $this->_setToView();
    }

    /**
     * build an array and assign data to view
     *
     */
    protected function _setToView()
    {
        $this->_controller->set(
            'breadcrumbs',
            [
                'crumbs' => $this->crumbs,
                'backLink' => $this->backLink
            ]
        );
    }
}
