<?php
namespace Ev3Assets\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * AssetRelations Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Foreigns
 * @property \Cake\ORM\Association\BelongsTo $RelatedForeigns
 *
 * @method \Ev3Assets\Model\Entity\AssetRelation get($primaryKey, $options = [])
 * @method \Ev3Assets\Model\Entity\AssetRelation newEntity($data = null, array $options = [])
 * @method \Ev3Assets\Model\Entity\AssetRelation[] newEntities(array $data, array $options = [])
 * @method \Ev3Assets\Model\Entity\AssetRelation|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \Ev3Assets\Model\Entity\AssetRelation patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \Ev3Assets\Model\Entity\AssetRelation[] patchEntities($entities, array $data, array $options = [])
 * @method \Ev3Assets\Model\Entity\AssetRelation findOrCreate($search, callable $callback = null)
 */
class AssetRelationsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('asset_relations');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Images', [
            'foreignKey' => 'foreign_id',
            'className' => 'Ev3Assets.Images'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('model', 'create')
            ->notEmpty('model');

        $validator
            ->requirePresence('related_model', 'create')
            ->notEmpty('related_model');

        $validator
            ->requirePresence('type', 'create')
            ->notEmpty('type');

        return $validator;
    }
}
