<?php
namespace Ev3Assets\Model\Behavior;

use Cake\ORM\Behavior;
use Cake\Utility\Inflector;
use Ev3Assets\Traits\AssetsTrait;

class AssetsBehavior extends Behavior
{
    use AssetsTrait;

    /**
     * Initialize hook
     *
     * @param array $config The config for this behavior.
     * @return void
     */
    public function initialize(array $config)
    {
        // We want to associated the model with the relevant assets defined for the behavior.
        foreach ($config as $model => $slots) {
            foreach ($slots as $type => $options) {
                $options = $this->_updateOptions($model, $type, $options);
                $this->_table->hasMany($options['joinTableAlias'], [
                    'className' => 'Ev3Assets.AssetRelations',
                    'foreignKey' => 'related_foreign_id',
                    'conditions' => [
                        'related_model' => $this->_table->alias(),
                        'model' => $model,
                        $options['joinTableAlias'] . '.type' => $type
                    ]
                ]);
            }
            $this->_table->hasMany(Inflector::singularize($model) . 'Assets', [
                'className' => 'Ev3Assets.AssetRelations',
                'foreignKey' => 'related_foreign_id',
                'conditions' => [
                    'related_model' => $this->_table->alias(),
                    'model' => $model
                ]
            ]);
        }
    }

    protected function _updateOptions($model, $type, $options)
    {
        if (!is_array($options)) {
            $options = [
                'slots' => $options
            ];
        }
        $options['joinTableAlias'] = $this->joinTableAlias($model, $type);
        $options['joinTable'] = Inflector::underscore($options['joinTableAlias']);
        // Update the behavior's config.
        $this->config($model . '.' . $type, $options);
        return $options;
    }
}
