<?php
namespace Ev3Assets\Listener;

use Cake\Collection\Collection;
use Cake\Event\Event;
use Cake\Utility\Hash;
use Cake\Utility\Inflector;
use Crud\Listener\BaseListener;

class AssetsListener extends BaseListener
{

    public function beforeFilter(Event $event)
    {
        // Disable security for add/edit action when we've got assets as we will need to inject form
        // fields for handling them.
        if ($this->_table()->behaviors()->has('Assets')) {
            $this->_controller()->Security->config('unlockedActions', ['add', 'edit']);
        }
    }

    public function beforeFind(Event $event)
    {
        if ($this->_table()->behaviors()->has('Assets')) {
            $config = $this->_table()->behaviors()->get('Assets')->config();
            foreach ($config as $model => $types) {
                foreach ($types as $type) {
                    $event->subject()->query->contain([$type['joinTableAlias'] => [$model]]);
                }
            }
        }
    }

    /**
     * Update the asset save data.
     * @param Event $event
     * @return void
     */
    public function beforeSave(Event $event)
    {
        if ($this->_table()->behaviors()->has('Assets')) {
            // We want to make sure that the related model is correctly set for our attached assets.
            $config = $this->_table()->behaviors()->get('Assets')->config();
            $data = &$event->subject()->entity;
            $tables = Hash::extract($config, '{s}.{s}.joinTable');
            foreach ($tables as $table) {
                foreach ($data->$table as &$asset) {
                    $asset->related_model = $this->_table()->alias();
                }
                $data->dirty($table);
            }
            // Remove existing assets to get replaced by the newly submitted data.
            $id = $data->{$this->_table()->primaryKey()};
            $assets = $this->_table()->ImageAssets->find('list')
                ->where(['related_model' => $this->_table()->alias()])
                ->where(['related_foreign_id' => $id])->toArray();
            if (!empty($assets)) {
                $this->_table()->ImageAssets->deleteAll([
                    'id IN' => $assets
                ]);
            }
        }
    }
}
