<?php
namespace Ev3Assets\Controller\Library;

use Cake\Event\Event;

class ImagesController extends AppController
{
    public function beforeFilter(\Cake\Event\Event $event)
    {
        $this->Crud->mapAction('index', 'Crud.Index');
        $this->Crud->mapAction('add', 'Crud.Add');
        $this->Crud->mapAction('edit', 'Crud.Edit');
        $this->Crud->mapAction('delete', 'Ev3Crud.Delete');
        parent::beforeFilter($event);
    }

    protected function index()
    {
        $action = $this->Crud->action();
        $action->config('scaffold.fields_blacklist', [
            'caption',
            'alt',
            'source_text',
            'source_url',
            'type',
            'size',
            'width',
            'height',
            'dir'
        ]);
        $this->viewBuilder()->template('Ev3Assets.library_index');
        return $this->Crud->execute();
    }

    protected function _form()
    {
        $action = $this->Crud->action();
        $action->config('scaffold.fields_blacklist', [
            'type',
            'size',
            'width',
            'height',
            'dir',
            'created',
            'modified'
        ]);
        $action->config('scaffold.field_settings', [
            'filename' => [
                'type' => 'file'
            ]
        ]);
        $action->config('scaffold.actions', []);
    }

    /**
     * Before render callback.
     *
     * @param \Cake\Event\Event $event The beforeRender event.
     * @return void
     */
    public function beforeRender(Event $event)
    {
        parent::beforeRender($event);
        $this->viewBuilder()->layout('library');
    }

    /**
     * Add an image to the library
     */
    public function add()
    {
        // Set up a redirect rule for handling the uploaded image so that we can inject it into the
        // relevant slot via JavaScript.
        $this->Crud->action()->redirectConfig('insert', [
            'reader' => 'request.data',
            'key' => '_insert',
            'url' => [
                'action' => 'insert',
                ['entity.field', 'id']
            ]
        ]);
        $action = $this->Crud->action();
        $action->config('scaffold.save_button', __d('ev3_assets', 'Add'));
        return $this->Crud->execute();
    }

    /**
     * Insert an uploaded image to the image slots. This action is redirected to after a successful
     * upload.
     * @param int $id Image ID
     * @return void
     */
    public function insert($id)
    {
        $this->set(compact('id'));
        $this->viewBuilder()->template('insert');
    }

}
