<?php
namespace Ev3Assets\Controller\Admin;

use Cake\Utility\Inflector;
use Ev3Assets\Traits\AssetsTrait;

class ImagesController extends AppController
{
    use AssetsTrait;

    public function beforeFilter(\Cake\Event\Event $event)
    {
        $this->Crud->mapAction('index', 'Crud.Index');
        $this->Crud->mapAction('add', 'Crud.Add');
        $this->Crud->mapAction('edit', 'Crud.Edit');
        $this->Crud->mapAction('delete', 'Ev3Crud.Delete');
        parent::beforeFilter($event);
    }

    /**
     * Configure the index listing.
     * @return \Cake\Network\Response
     */
    protected function index()
    {
        $action = $this->Crud->action();
        $action->config('scaffold.fields_blacklist', [
            'caption',
            'alt',
            'source_text',
            'source_url',
            'type',
            'size',
            'width',
            'height',
            'dir'
        ]);
        return $this->Crud->execute();
    }

    /**
     * Configure the add/edit forms.
     * @return void
     */
    protected function _form()
    {
        $action = $this->Crud->action();
        $action->config('scaffold.fields_blacklist', [
            'type',
            'size',
            'width',
            'height',
            'dir'
        ]);
        $action->config('scaffold.field_settings', [
            'filename' => [
                'type' => 'file'
            ]
        ]);
    }

    /**
     * Image preview for CMS forms
     * @param int $id Image asset ID
     * @param string $type Image type
     * @param int $key Position
     * @return void
     */
    public function preview($id, $type = 'main', $key = 0)
    {
        // Get the image.
        $image = $this->Images->get($id);
        $model = Inflector::underscore($this->joinTableAlias('Images', $type));
        $this->set(compact('image', 'key', 'model', 'type'));
        // Set the template.
        $this->viewBuilder()->template('preview');
        $this->viewBuilder()->templatePath('Images');
        $this->viewBuilder()->layout('ajax');
        // Disable the view class as this conflicts with the template path when an AJAX request is
        // made.
        $this->viewClass = null;
    }
}
