/**
 * Define action specific logic here. This then gets called from the library layout template and
 * provides a simple way of scoping functionality.
 *
 * LibraryApp.init() checks if there's any appropriate functionality and triggers it.
 * LibraryApp.actions defines the functionality for specific actions.
 *
 * @type {Object}
 */
LibraryApp = {
    init: function(action) {
        if (typeof this.actions[action] !== 'undefined') {
            return LibraryApp.actions[action]();
        }
    },
    actions: {
        index: initLibrary,
        insert: addToLibrary
    }
};

function initLibrary() {
    var type = $('.library').data('type') === 'document' ? 'document' : 'image';
    $('body').on('click', '.js-select-asset', selectAsset);

    function selectAsset(e) {
        var selected = $(this).data('id');
        if (type === 'document') {
            parent.addDocumentAssetPreview(selected);
        } else {
            parent.addImageAssetPreview(selected);
        }
        return false;
    }
}

function addToLibrary() {
    var type = $('.library').data('type') === 'document' ? 'document' : 'image';
    var selected = $('.js-ev3-assets-uploaded').data('id');
    if (selected > 0) {
        if (type === 'document') {
            parent.addDocumentAssetPreview(selected);
        } else {
            parent.addImageAssetPreview(selected);
        }
        return false;
    }
}
