// Include gulp
var gulp = require('gulp');

var concat = require('gulp-concat');
var uglify = require('gulp-uglify');
var rename = require('gulp-rename');
var sass = require('gulp-sass');

var bower = 'assets/bower_components/';

gulp.task('js', function() {
    return gulp.src([
            bower + 'jquery/dist/jquery.js',
            bower + 'jquery-ui/jquery-ui.js',
            bower + 'bootstrap-sass/assets/javascripts/bootstrap.js',
            'assets/js/*.js'
        ])
        .pipe(concat('admin.js'))
        .pipe(rename({suffix: '.min'}))
        .pipe(uglify())
        .pipe(gulp.dest('webroot/js'));;
});

gulp.task('sass', function() {
    return gulp.src([
            'assets/scss/styles.scss'
        ])
        .pipe(sass({outputStyle: 'compressed'}))
        .pipe(rename({suffix: '.min'}))
        .pipe(gulp.dest('webroot/css'));
});

gulp.task('watch', function() {
    // Watch .js files
    gulp.watch('assets/js/*.js', ['js']);
    // Watch .scss files
    gulp.watch(['assets/scss/*.scss', 'assets/scss/**/*.scss'], ['sass']);
});
