/**
 * WYSIWYG Editor plugin (TinyMCE wrapper)
 */
(function($){

    $.fn.wysiwygEditor = function(options) {
        if (typeof options === 'string' && options === 'remove') {
            $(this).each(function() {
                tinymce.execCommand('mceRemoveEditor', true, $(this).attr('id'));
            });
        } else {
            options = $.extend({}, $.fn.wysiwygEditor.defaults, options);
            if (typeof tinymce == 'object') {
                $(this).each(function(){
                    tinymce.settings = options;
                    // We're not using the jQuery plugin for TinyMCE as we need
                    // multiple versions of the editor which are not supported by the plugin.
                    tinymce.execCommand('mceAddEditor', true, $(this).attr('id'));
                    // We need to remove the 'required' attribute from the original textarea
                    // otherwise it causes conflicts in the browser when it tries to validate the
                    // form.
                    $(this).removeAttr('required');
                });
            }
        }
    };

    $.fn.wysiwygEditor.defaults = {
        'height': 500,
        'plugins': 'paste, table, code, link, lists',
        'theme': 'modern',
        'menubar': false,
        'toolbar': 'undo redo code | styleselect | bold italic | numlist bullist outdent indent | alignleft aligncenter alignright | link image table',
        'statusbar': false,
        // Restrict which HTML elements can be used in the editor (it's important
        // that anything included in the toolbar is listed here too).
        'valid_elements': 'p[*],br,a[title|target|href],strong,em,ul,ol,li,table,tbody,tr,th,td,h1,h2,h3,sup,sub,blockquote,pre,code,span[class],u',
        //'content_css': baseUrl + 'theme/Admin/css/wysiwyg.min.css?' + (new Date().getTime()),
        'formats': {
            'underline': {inline: 'u', exact: true}
        }
    };
})(jQuery);
