
$(function() {

	// Check the users browser can support both a webcam and html canvas
	var failedSupport = false;

	if ($('.browser-checks').length) {


		if ($('.browser-checks').attr('data-canvas') !== undefined) {
			if (Modernizr.canvas  === false) {
		      failedSupport = true;
		    }
		}


		if (failedSupport) {
			$('.browser-overlay').show();
		} else {

		}
	}

	if ($('#photoBox').length) {

		var camWidth = 640;
		var camHeight = 480;
		if (screen.width < screen.height) {
			width = 480;
			height = 640;
		}

		Webcam.set({
			width: camWidth, // live preview size
		    height: camHeight,
		    dest_width: camWidth, // device capture size
		    dest_height: camHeight,
		    crop_width: 370, // final cropped size
		    crop_height: 370,
	        image_format: 'jpeg',
	        jpeg_quality: 100,
	        force_flash: false,
	        flip_horiz: true,
	        fps: 45,

	    });

	    Webcam.on('error', function(err) {
	    	$('[data-skip-photo]').hide();
			$('.photo-box').hide();
			$('.button-take-photo').hide();
			$('.no-camera-notice').show();
		});

		Webcam.attach( '#photoBox' );

		Webcam.on('live', function() {
	    	$('[data-skip-photo]').show();
	        $('.button-take-photo').show();
	    });

		$('.button-take-photo').on('click touchend', function(e) {
			e.preventDefault();
			Webcam.freeze();

			$('.photo-details').hide();
			$('.photo-container').addClass('col-sm-4').addClass('col-sm-offset-4');

			$(this).hide();

			$('.button-retake-photo').show();
			$('.button-use-photo').show();
			$('.photo-header').hide();
			$('.photo-confirm-header').show();
		});

		$('.button-retake-photo').on('click touchend', function(e) {
			e.preventDefault();
			$(this).hide();
			$('.button-take-photo').show();
			$('.button-use-photo').hide();

			$('.photo-header').show();
			$('.photo-confirm-header').hide();

			$('.photo-container').removeClass('col-sm-4').removeClass('col-sm-offset-4');
			$('.photo-details').show();

			Webcam.unfreeze();
		});

		$('.button-use-photo').on('click touchend', function(e) {
			e.preventDefault();

			Webcam.snap(function (data_uri) {

				var raw_image_data = data_uri.replace(/^data\:image\/\w+\;base64\,/, '');

				$('.photofield').val(raw_image_data);

				$('form.photoform').submit();
				// Webcam.upload(data_uri, '', function (code, text) {
				//
				// });
			});
		});
	}

	if ($('form.signatureform').length) {
		var canvas = document.querySelector("canvas");

		var signaturePad = new SignaturePad(canvas, {
			backgroundColor: 'rgb(255,255,255)'
		});

		function resizeCanvas() {
			// When zoomed out to less than 100%, for some very strange reason,
			// some browsers report devicePixelRatio as less than 1
			// and only part of the canvas is cleared then.
			var ratio =  Math.max(window.devicePixelRatio || 1, 1);
			canvas.width = canvas.offsetWidth * ratio;
			canvas.height = canvas.offsetHeight * ratio;
			canvas.getContext("2d").scale(ratio, ratio);
		}

		//signaturePad.minWidth = 300;
		//signaturePad.maxWidth = 770;

		window.onresize = resizeCanvas;
		resizeCanvas();

		$('.confirm-btn').on('click touchend', function(e) {
			e.preventDefault();

			if (signaturePad.isEmpty()) {
				alert('Please use your mouse or finger to sign inside the box.');
			} else {

				var signature = signaturePad.toDataURL('image/png', 100);
				var raw_image_data = signature.replace(/^data\:image\/\w+\;base64\,/, '');

				$('input.signature').val(raw_image_data);

				$('form.signatureform').submit();
			}

		});

	}
});

function checkWaiverAge() {
	$('.waiver-datepicker').each(function() {
		if ($(this).val() !== '') {
			var today = new Date();
			var currentDay = today.getDate();
			var currentYear = today.getFullYear();
			var currentMonth = today.getMonth();

			var birthDate = new Date($(this).val());

			var birthDay = birthDate.getDate();
			var birthMonth = (birthDate.getMonth()) + 1;
			var birthYear = birthDate.getFullYear();

			var age = currentYear - birthYear;

			if (currentMonth < birthMonth - 1) {
				age--;
			}

			if (birthMonth - 1 == currentMonth && currentDay < birthDay) {
				age--;
			}

			var participantRow = $(this).closest('.participantRow');

			if (age < 18) {
				$(this).closest('.participantRow').find('.waiver-adult').each(function() {
					$(this).slideDown();

				});

				var emailVal = $(this).closest('.participantRow').find('.waiver-email').find('input').val();
				$(this).closest('.participantRow').find('.waiver-adult-email').find('input').val(emailVal);

				$(this).closest('.participantRow').find('.waiver-email').slideUp();
				if ($(this).closest('.participantRow').find('.waiver-btn').is(':visible')) {
					$(this).closest('.participantRow').find('.waiver-btn').hide();
				}

			} else {
				$(this).closest('.participantRow').find('.waiver-adult').each(function() {
					$(this).slideUp('fast', function(e) {
						fieldsComplete(participantRow);

						runFieldChecks();
					});
				});
				$(this).closest('.participantRow').find('.waiver-email').slideDown();
			}

			fieldsComplete($(this).closest('.participantRow'));
		}
	});
}

function fieldsComplete(element) {
	var complete = false;
	var isAdult = false;

	if ($(element).find('.waiver-adult').is(':visible')) {
		isAdult = true;

		// Copy over the email value
		if (! $(element).find('.waiver-adult-email').val() && $(element).find('.waiver-email').val()) {
			var email = $(element).find('.waiver-email').find('input').val();
			$(element).find('.waiver-adult-email').find('input').val(email);
		}
	}

	var adultFieldsFilled = 0;
	var emptyFields = 0;

	var firstName = $(element).find('[data-type=first_name]');
	var lastName = $(element).find('[data-type=last_name]');
	var email = $(element).find('[data-type=email]');
	var dob = $(element).find('[data-type=date_of_birth]');

	var adultFirstName = $(element).find('[data-type=adult_first_name]');
	var adultLastName = $(element).find('[data-type=adult_last_name]');
	var adultEmail = $(element).find('[data-type=adult_email]');
	var adultDob = $(element).find('[data-type=adult_date_of_birth]');

	if (isAdult) {

		if (
			firstName.val() &&
			lastName.val() &&
			dob.val() &&
			adultFirstName.val() &&
			adultLastName.val() &&
			adultEmail.val() &&
			adultDob.val()
		) {
			complete = true;
		}
	} else {
		if (
			firstName.val() &&
			lastName.val() &&
			dob.val() &&
			email.val()
		) {
			complete = true;
		}
	}

	return complete;
}

function showButton(element) {

	if ($(element).find('.waiver-adult').is(':visible')) {
		$(element).find('.waiver-btn-adult').show();
	} else {
		$(element).find('.waiver-btn').show();
	}
}

function hideButton(element) {
	$(element).find('.waiver-btn-adult').hide();
	$(element).find('.waiver-btn').hide();
}

function waiverFormRows() {
	$('.participantRow').each(function(e) {

		var element = $(this);
		fieldsComplete(element);

		$(this).find('input').on('change', function(e) {
			if (fieldsComplete(element)) {
				console.log('complete');
				showButton(element);
			} else {
				hideButton(element);
			}
		});
	});
}

$(window).ready(function() {
	//resizeCanvas();
	waiverFormRows();
	if ($('.conditions-btn') !== 'undefined') {

		if ($('input[type="checkbox"]:checked').length == $('input[type="checkbox"]').length) {
			// All checked
			$('.conditions-btn').prop('disabled', false);
		} else {
			$('.conditions-btn').prop('disabled', true);
		}


		$('input[type="checkbox"]').on('change', function(e) {
			if ($('input[type="checkbox"]:checked').length == $('input[type="checkbox"]').length) {
				// All checked
				$('.conditions-btn').prop('disabled', false);
			} else {
				$('.conditions-btn').prop('disabled', true);
			}
		});
	}
});

$(window).on('load', function() {

	checkWaiverAge();

	if ($('.waiver-datepicker') !== 'undefined') {
		$('.waiver-datepicker').on('change', function() {
			$.when(checkWaiverAge()).then(function() {
				runFieldChecks();
			});

		});
	}

	$('.participantRow').each(function(e) {
		var element = $(this);
		if (fieldsComplete(element)) {
			showButton(element);
		} else {
			hideButton(element);
		}
	});
});

function runFieldChecks() {
	$('.participantRow').each(function(e) {
		var element = $(this);
		if (fieldsComplete(element)) {
			showButton(element);
		} else {
			hideButton(element);
		}
	});
}
