BuzzWaivers
===========

This plugin handles waivers for bookings on the Twinwoods Suite of sites.

Installation
------------

This plugin uses a SOAP API to post data (used for photos and signatures). These need configuring in the database.php file as `$SOAPApi` and `$SOAPtestApi`. For example:-

	public $SOAPApi = array(
		'datasource' => 'BuzzSource.SoapSource',
		'database' => false,
		'wsdl' => 'http://engine.bodyflight.co.uk/BookingEngineService.svc?wsdl'
	);

	public $SOAPtestApi = array(
		'datasource' => 'BuzzSource.SoapSource',
		'database' => false,
		'wsdl' => 'http://bookingenginetest.bodyflight.co.uk/BookingEngineService.svc?wsdl'
	);

The waivers also need enabling via the plugin's config.

 * `showOnBookingConfirmation` - set this to true to show the participant fields on the booking confirmation page
 * `showOnCheckBooking` - set this to true to show the sign waivers buttons from Check My Booking

To make sure participants are sent emails linking to the waiver forms the event listener needs attaching:-

	App::uses('WaiverListener', 'BuzzWaivers.Lib/Event');
	CakeEventManager::instance()->attach(new WaiverListener());
