<div class="participantRow">
	<div class="row listing">
		<div class="col-xs-12 col-sm-1">
			<h4><i class="fa fa-user"></i> <?=$participantNo?></h4>
		</div>
		<div class="col-xs-12 col-sm-4">
			<?=$this->Form->addField('Participant.' . $participant['Participant']['id'] . '.first_name', array(
				'type' => 'string',
				'value' => $participant['Participant']['first_name'],
				'data-type' => 'first_name'
			))?>
			<?=$this->Form->addField('Participant.' . $participant['Participant']['id'] . '.last_name', array(
				'type' => 'string',
				'value' => $participant['Participant']['last_name'],
				'data-type' => 'last_name'
			))?>
		</div>
		<div class="col-xs-12 col-sm-5">
			<?=$this->Form->addField('Participant.' . $participant['Participant']['id'] . '.date_of_birth', array(
				'type' => 'string',
				'class' => 'datepicker waiver-datepicker',
				'label' => 'Date of Birth',
				'placeholder' => 'YYYY-MM-DD',
				'data-show-years' => true,
				'value' => $this->Time->format($participant['Participant']['date_of_birth'], '%Y-%m-%d'),
				'data-type' => 'date_of_birth'
			))?>
			<?=$this->Form->addField('Participant.' . $participant['Participant']['id'] . '.email', array(
				'type' => 'string',
				'value' => $participant['Participant']['email'],
				'div' => 'waiver-email input text',
				'data-type' => 'email'
			))?>
		</div>

		<div class="col-xs-12 col-sm-2">
			<?=$this->Form->button('Sign Waiver <i class="fa fa-chevron-circle-right"></i>', array(
				'class' => 'button background--quinary waiver-btn',
				'text' => 'Sign Waiver',
				'escape' => false,
				'value' => $participant['Participant']['id'],
				'name' => 'sign_waiver',
				'style' => 'display: none'
			))?>
		</div>
	</div>
	<div class="row listing waiver-adult waiver-adult-heading" style="display: none">
		<div class="col-xs-12 text-center">
			<p class="waiver-notice">This person is under 18 and needs an adult to check in on their behalf</p>
		</div>
	</div>

	<div class="row listing waiver-adult waiver-adult-fields" style="display: none">

		<div class="col-xs-12 col-sm-1">

		</div>

		<div class="col-xs-12 col-sm-4">
			<?=$this->Form->addField('Participant.' . $participant['Participant']['id'] . '.adult_first_name', array(
				'type' => 'string',
				'value' => $participant['Participant']['adult_first_name'],
				'div' => 'row',
				'class' => 'col-xs-6',
				'data-adult-field' => true,
				'label' => array(
					'class' => 'col-xs-6',
					'text' => 'Adult First Name'
				),
				'data-type' => 'adult_first_name'
			))?>
			<?=$this->Form->addField('Participant.' . $participant['Participant']['id'] . '.adult_last_name', array(
				'type' => 'string',
				'value' => $participant['Participant']['adult_last_name'],
				'div' => 'row',
				'class' => 'col-xs-6',
				'data-adult-field' => true,
				'label' => array(
					'class' => 'col-xs-6',
					'text' => 'Adult Last Name'
				),
				'data-type' => 'adult_last_name'
			))?>
		</div>
		<div class="col-xs-12 col-sm-5">
			<?php
			$date = new DateTime();
			$maxDate = $date->modify('-18 years')->format('Y-m-d H:i:s');
			?>
			<?=$this->Form->addField('Participant.' . $participant['Participant']['id'] . '.adult_date_of_birth', array(
				'type' => 'string',
				'class' => 'datepicker col-xs-6',
				'data-show-years' => true,
				'placeholder' => 'YYYY-MM-DD',
				'value' => $this->Time->format($participant['Participant']['adult_date_of_birth'], '%Y-%m-%d'),
				'div' => 'row',
				'data-adult-field' => true,
				'data-max-date' => $maxDate,
				'label' => array(
					'class' => 'col-xs-6',
					'text' => 'Adult Date of Birth'
				),
				'data-type' => 'adult_date_of_birth'
			))?>
			<?=$this->Form->addField('Participant.' . $participant['Participant']['id'] . '.adult_email', array(
				'type' => 'string',
				'value' => $participant['Participant']['email'],
				'div' => 'row waiver-adult-email',
				'class' => 'col-xs-6',
				'data-adult-field' => true,
				'label' => array(
					'class' => 'col-xs-6',
					'text' => 'Adult Email'
				),
				'data-type' => 'adult_email'
			))?>
		</div>
		<div class="col-xs-12 col-sm-2">
			<?=$this->Form->button('Sign Waiver <i class="fa fa-chevron-circle-right"></i>', array(
				'class' => 'button background--quinary waiver-btn-adult',
				'text' => 'Sign Waiver',
				'escape' => false,
				'value' => $participant['Participant']['id'],
				'name' => 'sign_waiver',
				'style' => 'display: none',
			))?>
		</div>
	</div>
	<hr />
</div>
