<?php
if (empty($data['booking_ref'])):
	return;
endif;

$createUrl = [
	'plugin' => 'buzz_waivers',
	'controller' => 'waivers',
	'action' => 'create_waivers',
	$data['api_booking_ref']
];

$buttonText = __d('buzz_waivers', 'View Participant Details');

if (! empty($participants[$data['booking_ref']])):
	$participantUrl = array(
		'plugin' => 'buzz_waivers',
		'controller' => 'waivers',
		'action' => 'participants',
		$participants[$data['api_booking_ref']]
	);

	if (! empty($kiosk)):
		$participantUrl = '/kiosk/' . $this->Html->url($participantUrl);
		$createUrl = '/kiosk/' . $this->Html->url($createUrl);
	endif;

	if (! empty($data['requires_waiver'])):
		$buttonText = __d('buzz_waivers', 'Sign Waivers');
	endif;
?>

	<div class="row">
		<div class="col-xs-12 text-right">
			<?=$this->Html->link($buttonText . ' <i class="fa fa-chevron-circle-right"></i>', $participantUrl, array(
				'escape' => false,
				'class' => 'button confirm-btn'
			))?>
		</div>
	</div>
<?php
else:
	if ($data['requires_waiver'] == '1'):
		$buttonText = __d('buzz_waivers', 'Sign Waivers');
	endif;
?>

	<div class="row">
		<div class="col-xs-12 text-right">
			<?= $this->Html->link($buttonText . ' <i class="fa fa-chevron-circle-right"></i>', $createUrl, array(
				'escape' => false,
				'class' => 'button confirm-btn'
			)) ?>
		</div>
	</div>
<?php endif; ?>
