<?php
	// If this is a private hire booking with no defined participant numbers we don't want to show
	// participant fields.
	$totalParticipants = array_sum(Hash::extract($data, 'BookingItem.{n}.participants'));
	if ($totalParticipants < 1):
		return;
	endif;
?>
<hr />
<h4>
	<?=__d('buzz_waivers', 'Please enter a contact name and email address for each participant so we can contact them about signing a waiver.')?>
</h4>

<?= $this->Form->create('BuzzWaivers.Detail', array(
	'url' => array(
		'plugin' => 'buzz_waivers',
		'admin' => false,
		'controller' => 'waivers',
		'action' => 'complete_booking',
		$data['Booking']['sales_ref']
	),
	'class' => 'form--side-labels form--compact-alt validate'
)) ?>

<?php $i = 0; ?>
<?php foreach ($data['BookingItem'] as $bookingItem): ?>
		<?php
			if (! empty($bookingItem['BookingItemVoucher'])) {
				$label = h($bookingItem['BookingItemVoucher']['name']);
			} else {
				$label = $this->I18n->translate($bookingItem, 'ActivityPackage.name');
			}
			$participants = $bookingItem['participants'] * $bookingItem['quantity'];
			if ($participants < 1):
				continue;
			endif;
		?>
		<h5><?= $label ?></h5>
		<?php for ($participant = 1; $participant <= $participants; $participant++): ?>
			<div class="participant-waiver-row row listing">
				<div class="col-xs-12 col-sm-1">
					<i class="fa fa-user"></i> <strong><?= $participant ?></strong>
				</div>
				<div class="col-xs-12 col-sm-11">
					<div class="row">
						<div class="col-xs-12 col-sm-4">
							<?= $this->Form->hidden('Participant.' . $i . '.booking_item_id', ['value' => $bookingItem['id']]) ?>
							<?= $this->Form->input('Participant.' . $i . '.first_name', ['label' => __d('buzz_waivers', 'First Name')]) ?>
						</div>

						<div class="col-xs-12 col-sm-4">
							<?= $this->Form->input('Participant.' . $i . '.last_name', ['label' => __d('buzz_waivers', 'Last Name')]) ?>
						</div>

						<div class="col-xs-12 col-sm-4">
							<?= $this->Form->input('Participant.' . $i . '.email', ['label' => __d('buzz_waivers', 'Email'), 'type' => 'email']) ?>
						</div>
					</div>
				</div>
			</div>
			<?php $i++; ?>
		<?php endfor; ?>
<?php endforeach; ?>

<div class="row">
	<div class="col-xs-12 col-sm-4 pull-right">
		<?php
		echo $this->Form->button(__d('buzz_waivers', 'Submit Contact Information') . ' <i class="fa fa-chevron-circle-right"></i>', array(
			'type' => 'submit',
			'class' => 'button right button--block'
		));
		?>
	</div>
</div>
<?= $this->Form->end() ?>
