<?php
/**
 * BuzzWaiverParticipantFixture
 *
 */
class BuzzWaiverParticipantFixture extends CakeTestFixture {

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
		'sales_ref' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
		'model' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
		'model_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
		'first_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
		'last_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
		'email' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
		'date_of_birth' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'adult_first_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
		'adult_last_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
		'adult_email' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
		'adult_date_of_birth' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'emailed' => array('type' => 'boolean', 'null' => true, 'default' => '0'),
		'waiver_complete' => array('type' => 'boolean', 'null' => true, 'default' => null, 'key' => 'unique'),
		'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1),
			'waiver_complete_UNIQUE' => array('column' => 'waiver_complete', 'unique' => 1)
		),
		'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_bin', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'sales_ref' => 1,
			'model' => 'Lorem ipsum dolor sit amet',
			'model_id' => 1,
			'first_name' => 'Lorem ipsum dolor sit amet',
			'last_name' => 'Lorem ipsum dolor sit amet',
			'email' => 'Lorem ipsum dolor sit amet',
			'date_of_birth' => '2016-12-01 17:16:23',
			'adult_first_name' => 'Lorem ipsum dolor sit amet',
			'adult_last_name' => 'Lorem ipsum dolor sit amet',
			'adult_email' => 'Lorem ipsum dolor sit amet',
			'adult_date_of_birth' => '2016-12-01 17:16:23',
			'emailed' => 1,
			'waiver_complete' => 1,
			'created' => '2016-12-01 17:16:23',
			'modified' => '2016-12-01 17:16:23'
		),
	);

}
