<?php
App::uses('BuzzWaiversAppModel', 'BuzzWaivers.Model');
App::uses('CakeText', 'Utility');
/**
 * Participant Model
 *
 */
class Participant extends BuzzWaiversAppModel {

	public $virtualFields = array(
		'name' => '
			CASE WHEN (Participant.adult_first_name IS NOT NULL AND Participant.adult_first_name != \'\') THEN
				CONCAT("Adult: ", Participant.adult_first_name, " ", Participant.adult_last_name, " Child: ", Participant.first_name, " ", Participant.last_name)
			ELSE
				CONCAT(Participant.first_name, " ", Participant.last_name)
			END
		'
	);

	public $hasAndBelongsToMany = array(
		'Condition' => array(
			'className' => 'BuzzWaivers.Condition',
			'joinTable' => 'buzz_waivers_participant_conditions'
		)
	);

/**
 * Primary key field
 *
 * @var string
 */
	public $primaryKey = 'id';

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'email';

/**
 * Validation rules
 * @var array
 */
	public $validate = [
		'first_name' => [
			'max' => [
				'rule' => ['maxLength', 250],
				'message' => 'No more than 250 characters long',
				'allowEmpty' => true
			]
		],
		'last_name' => [
			'max' => [
				'rule' => ['maxLength', 250],
				'message' => 'No more than 250 characters long',
				'allowEmpty' => true
			]
		],
		'email' => [
			'valid_email' => [
				'rule' => 'email',
				'message' => 'A valid email address is required',
				'allowEmpty' => true
			],
			'max' => [
				'rule' => ['maxLength', 250],
				'message' => 'No more than 250 characters long',
				'allowEmpty' => true
			]
		]
	];

	public function beforeSave($options = array()) {
		if (empty($this->data['Participant']['id']) && empty($this->id)) {
			$this->data['Participant']['id'] = CakeText::uuid();
		}

		return parent::beforeSave($options);
	}

/**
 * Get all the known participants for a booking
 * @param int $salesRef Sales Ref
 * @param int $bookingRef Booking Ref
 * @return array
 */
	public function getBookingParticipants($salesRef, $bookingRef) {
		return $this->find('all', [
			'fields' => [
				'Participant.*',
				'BookingItemPlace.*'
			],
			'joins' => [
				[
					'table' => 'booking_item_places',
					'alias' => 'BookingItemPlace',
					'type' => 'LEFT',
					'conditions' => 'Participant.api_booking_ref = BookingItemPlace.api_reference'
				]
			],
			'conditions' => [
				'Participant.sales_ref' => $salesRef,
				'Participant.api_booking_ref' => $bookingRef
			],
			'order' => [
				'Participant.waiver_complete DESC',
				'Participant.first_name DESC',
			]
		]);
	}
}
