<?php

App::uses('CakeEventListener', 'Event');

class WaiverListener implements CakeEventListener {

/**
 * Implemented events
 * @return array
 */
	public function implementedEvents() {
		return array(
			'Model.Participant.afterCreate' => 'sendEmails'
		);
	}

/**
 * Send participants emails asking them to sign the waivers.
 * @param CakeEvent $Event Event object
 * @return void
 */
	public function sendEmails(CakeEvent $Event) {
		if (! empty($Event->data['salesRef'])) {
			// Load all participants we've not yet emailed with this ref
			$Participant = ClassRegistry::init('BuzzWaivers.Participant');
			$participants = $Participant->find('all', [
				'conditions' => [
					'sales_ref' => $Event->data['salesRef'],
					'emailed' => 0,
					'api_booking_ref <>' => null
				]
			]);

			if (! empty($participants)) {
				$Booking = ClassRegistry::init('BuzzBookings.Booking');
				$systemBooking = $Booking->find('first', [
					'conditions' => [
						'sales_ref' => $Event->data['salesRef']
					]
				]);
			}

			if (! empty($systemBooking)) {
				$purchase = ClassRegistry::init('BuzzBookings.Booking')->getPurchase($systemBooking['Booking']['id']);
				$bookingItemPlaces = Hash::combine(
					$purchase,
					'BookingItem.{n}.BookingItemPlace.{n}.api_reference',
					'BookingItem.{n}.BookingItemPlace.{n}.name'
				);
				$Controller = new Controller();
				$Controller->helpers = ['BuzzTranslate.I18n'];
				$View = new View($Controller);
				$View->set('data', $purchase);
				$details = $View->render('BuzzBookings./Bookings/email_basket', 'ajax');
				$Email = ClassRegistry::init('BuzzEmails.Email');
				foreach ($participants as $key => $participant) {
					$waiverUrl = Router::url([
						'plugin' => 'buzz_waivers',
						'controller' => 'waivers',
						'action' => 'participants',
						$participant['Participant']['id']
					], true);
					$waiverLink = '<a href="' . $waiverUrl . '">' . $waiverUrl . '</a>';
					$emailData = $Email->generateEmailData(
						'BuzzWaivers.waiver_notice',
						[
							'firstName' => $participant['Participant']['first_name'],
							'lastName' => $participant['Participant']['last_name'],
							'bookedItem' => $bookingItemPlaces[$participant['Participant']['api_booking_ref']],
							'date' => date('j F Y', strtotime($purchase['Booking']['booking_date'])),
							'time' => date('H:i', strtotime($purchase['Booking']['booking_date'])),
							'salesRef' => $purchase['Booking']['sales_ref'],
							'checkin' => $purchase['Booking']['check_in_time'],
							'waiverLink' => $waiverLink,
							'details' => $details
						]
					);
					$Email->queueEmail(
						$emailData['Email']['subject'],
						$emailData['Email']['content'],
						array($participant['Participant']['email'] => $participant['Participant']['first_name'] . ' ' . $participant['Participant']['last_name']),
						$emailData['Email']['from']
					);

					$participants[$key]['Participant']['emailed'] = true;
				}

				$Participant->saveMany($participants);
			}
		}

		return;
	}

}
