<?php
App::uses('BuzzWaiversAppController', 'BuzzWaivers.Controller');

class ParticipantsController extends BuzzWaiversAppController {

	protected function _adminFormFields() {
		return array();

		$fields = parent::_adminformFields();

		unset($fields['Participant.model']);
		unset($fields['Participant.model_id']);
		unset($fields['Participant.waiver_id']);
		unset($fields['Participant.child_waiver_id']);

		return $fields;
	}

	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();
		unset($columns['Participant.id']);

		$columns['Participant.email']['label'] = 'Adult Email';

		$newColumns = array(
			'Participant.sales_ref' => array(
				'type' => 'string',
				'label' => 'Sales Ref'
			),
			'Participant.name' => array(
				'type' => 'string',
				'label' => 'Participant Name'
			),
			'Participant.email' => array(
				'type' => 'string',
				'label' => 'Email'
			),
			'Participant.waiver_complete' => array(
				'type' => 'boolean',
				'label' => 'Waiver Complete?'
			)
		);

		return $newColumns + $columns;
	}

	protected function _adminFilterFields() {
		$fields = parent::_adminFilterFields();
		unset($fields['Participant.id']);

		$fields['Participant.email']['label'] = 'Adult Email';

		$newFields = array(
			'Participant.sales_ref' => array(
				'label' => 'Sales Ref',
				'type' => 'string',
				'compare' => array(
					'Participant.sales_ref LIKE' => '%%%s%%'
				)
			),
			'Participant.first_name' => array(
				'label' => 'First Name',
				'type' => 'string',
				'compare' => array(
					'Participant.first_name LIKE' => '%%%s%%'
				)
			),
			'Participant.last_name' => array(
				'label' => 'Last Name',
				'type' => 'string',
				'compare' => array(
					'Participant.last_name LIKE' => '%%%s%%'
				)
			)
		);

		return $newFields + $fields;
	}

	protected function _adminIndexActions() {
		return array('View');
	}

	protected function _adminIndexToolbar() {
		return array();
	}

	/**
	 * View Redirect
	 *
	 * Used to allow an admin link direct to the waiver form
	 */
	public function view($id) {
		$config = Configure::read('BuzzWaivers.stages.default');
		reset($config);
		$firstStage = key($config);

		$this->redirect(Router::url(array(
			'admin' => false,
			'plugin' => 'buzz_waivers',
			'controller' => 'waivers',
			'action' => 'stage',
			$firstStage,
			$id
		)));
	}

	// Disable this so we can use the ticks as a simple yes/no type field - theres
	// never going to be a need to activate/deactivate anything on these.

	public function admin_toggle($field, $id) {
		exit;
	}
}
