<?php
App::Uses('BuzzWaiversComponent', 'BuzzWaivers.Controller/Component');

class PreStageComponent extends BuzzWaiversComponent {

	public function loadTerms() {
		$this->_controller->loadModel('BuzzWaivers.Tab');
		$tabs = $this->_controller->Tab->find('all', array(
			'conditions' => array(
				'Tab.is_active' => 1
			),
			'order' => 'Tab.sequence asc'
		));

		$route = array(
			'plugin' => 'buzz_waivers',
			'controller' => 'waivers',
			'action' => 'step2',
			$this->participant['Participant']['id']
		);

		if ($this->_controller->kiosk) {
			$route['kiosk'] = 'kiosk';
		}

		$step2Url = Router::url($route);

		$this->_controller->set(compact('tabs', 'step2Url'));

		return true;
	}

	public function loadConditions() {
		$this->_controller->loadModel('BuzzWaivers.Condition');
		$conditions = $this->_controller->Condition->find('all', array(
			'conditions' => array(
				'is_active' => 1
			),
			'order' => 'sequence asc'
		));

		$this->_controller->set(compact('conditions'));

		return true;
	}

	public function processComplete() {
		if (! empty($this->participant)) {
			$this->_controller->Participant->save(array(
				'id' => $this->id,
				'waiver_complete' => 1
			));
		}

		return true;
	}

}
