<?php
App::Uses('BuzzWaiversComponent', 'BuzzWaivers.Controller/Component');

class PostStageComponent extends BuzzWaiversComponent {

	public function processConditions() {
		if (! empty($this->_controller->request->data['Condition'])) {
			$this->_controller->loadModel('BuzzWaivers.ParticipantCondition');

			$data = array();
			foreach ($this->_controller->request->data['Condition'] as $conditionId => $state) {

				if ($state == '1') {
					$data[] = array(
						'condition_id' => $conditionId,
						'participant_id' => $this->participant['Participant']['id']
					);
				}
			}

			if (! empty($data)) {
				$this->_controller->ParticipantCondition->deleteAll(array(
					'ParticipantCondition.participant_id' => $this->participant['Participant']['id']
				));

				$this->_controller->ParticipantCondition->saveMany($data);

				$this->participant['Condition'] = $data;
			}
		}

		return true;
	}

	public function processPhoto() {
		if ($this->_controller->request->is('put') || $this->_controller->request->is('post')) {
			if (empty($this->_controller->request->data['Photo']['photo'])) {
				// Photo step has been skipped so we don't need to process anything.
				return true;
			}

			$file = base64_decode($this->_controller->request->data['Photo']['photo']);

			// Temp save photo as if it was just uploaded
			$tmpFile = tempnam('/tmp', 'buzzwaivers-photo-' . $this->id);

			$handle = fopen($tmpFile, "w");
			fwrite($handle, $file);

			// Reconstruct photo data
			$imageData = array(
				'filename' => array(
					'name' => $this->id . '-photo.jpg',
					'type' => 'image/jpeg',
					'tmp_name' => $tmpFile,
					'error' => 0,
					'size' => strlen($file)
				)
			);

			$this->_controller->loadModel('EvCore.Image');

			$this->_controller->Image->set(array(
				'model' => 'Participant',
				'model_id' => $this->id,
				'attachment_type' => 'PhotoImage'
			));

			$this->_controller->Image->set($imageData);

			if (! $this->_controller->Image->save()) {
				$this->_controller->Session->setFlash(
					__d('buzz_waivers', 'There was a problem saving youe photo. Please try again.'),
					'flash_fail'
				);

				return false;
			}

			$this->_controller->loadModel('BuzzWaivers.WaiversApi');
			$this->_controller->WaiversApi->addWaiverPhoto(
				'Participant',
				$this->participant['Participant']['id'],
				array(
					'waiverId' => $this->participant['Participant']['waiver_id'],
					'photo' => $this->_controller->request->data['Photo']['photo']
				)
			);

			// Mark photo as complete on the waiver
			$this->_controller->loadModel('BuzzWaivers.Participant');
			$this->_controller->Participant->id = $this->id;
			$this->_controller->Participant->set('photo_complete', '1');
			$this->_controller->Participant->save();

			return true;
		}

		return false;
	}

	public function processSignature() {
		if ($this->_controller->request->is('post') || $this->_controller->request->is('put')) {
			$file = base64_decode($this->_controller->request->data['Signature']['signature']);

			// Temp save signature as if it was just uploaded
			$tmpFile = tempnam('/tmp', 'buzzwaivers-signature-' . $this->id);

			$handle = fopen($tmpFile, "w");
			fwrite($handle, $file);

			// Reconstruct signature data
			$imageData = array(
				'filename' => array(
					'name' => $this->id . '-signature.png',
					'type' => 'image/png',
					'tmp_name' => $tmpFile,
					'error' => 0,
					'size' => strlen($file)
				)
			);

			$this->_controller->loadModel('EvCore.Image');

			$this->_controller->Image->set(array(
				'model' => 'Participant',
				'model_id' => $this->id,
				'attachment_type' => 'SignatureImage'
			));

			$this->_controller->Image->set($imageData);

			if (! $this->_controller->Image->save()) {
				$this->_controller->Session->setFlash(
					__d('buzz_waivers', 'There was a problem saving your photo. Please try again.'),
					'flash_fail'
				);

				return false;
			}

			$this->_controller->loadModel('BuzzWaivers.WaiversApi');
			$waiverId = $this->_controller->WaiversApi->signWaiver(
				'Participant',
				$this->participant['Participant']['id'],
				$this->participant,
				$this->_controller->request->data['Signature']['signature']
			);

			if ($waiverId > 0) {
				$this->_controller->Session->setFlash(
					__d('buzz_waivers', 'Your signature was saved.'),
					'flash_success'
				);
				// Mark signature as complete on the waiver
				$this->participant['Participant']['waiver_id'] = $waiverId;
				$this->participant['Participant']['signature_complete'] = true;

				// Check if the waiver is for a child - if so, save the waiver for them as well.
				$dob = $this->participant['Participant']['date_of_birth'];
				if (strtotime($dob) > strtotime('-18 years')) {
					$childWaiverId = $this->_controller->WaiversApi->signChildWaiver(
						'Participant',
						$this->participant['Participant']['id'],
						$this->participant,
						$waiverId
					);
					if ($childWaiverId > 0) {
						$this->participant['Participant']['child_waiver_id'] = $childWaiverId;
					}
				}

				$this->saveParticipant();

				return true;
			}
		}

		return false;
	}

	public function processSignWaiver() {
		$this->_controller->WaiversApi->clear();

		// Reload the participant as we've likely only just updated the data
		$this->loadParticipant();

		// Check if the participant has already got a waiver id
		if ($this->participant['Participant']['waiver_id'] > 0) {
			return true;
		}

		if (! empty($this->participant['Condition'])) {
			$this->_controller->loadModel('BuzzWaivers.WaiversApi');

			$response = $this->_controller->WaiversApi->signWaiver(
				'Participant',
				$this->participant['Participant']['id'],
				$this->participant
			);

			if ($response > 0) {
				$this->participant['Participant']['waiver_id'] = $response;

				// Check if the waiver is for a child - if so, save the waiver
				// for them as well.
				$dob = $this->participant['Participant']['date_of_birth'];

				if (strtotime($dob) > strtotime('-18 years')) {
					// Child
					$response = $this->_controller->WaiversApi->signChildWaiver(
						'Participant',
						$this->participant['Participant']['id'],
						$this->participant
					);

					if ($response > 0) {
						$this->participant['Participant']['child_waiver_id'] = $response;
					}
				}

				$this->saveParticipant();
			}
		}

		return true;
	}

}
