<?php
App::uses('Component', 'Controller');

class BuzzWaiversComponent extends Component {

	protected $_controller = null;

	public $kioskMode = false;

	public $participant = null;

	public $booking = null;

	public $id = null;

/**
 * Sets a reference to the calling controller from within the component.
 *
 * @see Component::initialize()
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);
		$this->_controller = $controller;

		if ($this->_controller->request->params['action'] == 'stage') {

			if (! empty($this->_controller->request->params['kiosk'])) {
				$this->kioskMode = true;

				$this->_controller->layout = 'BuzzWaivers.Kiosk';
			}

			if (! empty($this->_controller->request->params['pass'][1])) {
				$this->id = $this->_controller->request->params['pass'][1];

				$this->loadParticipant();
			}
		}
	}

/**
 * Load the participant details from a pre defined record id, then retrieve the
 * booking from the api using that data and set the booking data and participant
 * back into the view.
 *
 * @return boolean Returns true if a waiver is still needed for the loaded participant
 */
	public function loadParticipant() {
		$this->_controller->loadModel('BuzzWaivers.Participant');
		$this->_controller->loadModel('BuzzWaivers.WaiversApi');
		$this->participant = $this->_controller->Participant->find('first', array(
			'conditions' => array(
				'id' => $this->id
			),
			'contain' => array(
				'Condition'
			)
		));

		if (empty($this->participant)) {
			throw new NotFoundException();
		}

		$this->_controller->set('participant', $this->participant);

		if (
			! empty($this->participant['Participant']['sales_ref']) &&
			! empty($this->participant['Participant']['booking_date'])
		) {
			$this->booking = $this->_controller->WaiversApi->getBooking(
				$this->participant['Participant']['sales_ref'],
				$this->participant['Participant']['booking_date']
			);
			$this->_controller->set('booking', $this->booking);
		}

		if ($this->participant['Participant']['waiver_complete'] == '1') {
			return false;
		}

		return true;
	}

/**
 * Saves a participant that is already loaded by the controller. This is mainly
 * used when we inject into the last step of BuzzBookings, where we ask for the
 * participant details. This simply uses that info and saves the partly populated
 * waiver/participant record.
 *
 * @return void
 */
	public function saveParticipant() {
		$this->_controller->loadModel('BuzzWaivers.Participant');
		$this->_controller->Participant->save($this->participant['Participant'], false);

		$this->loadParticipant();
	}

}
