<?php
App::uses('BuzzWaiversComponent', 'BuzzWaivers.Controller/Component');

class BookingCheckComponent extends BuzzWaiversComponent {

	protected $_controller = null;

/**
 * Check for a waiver existing, and populate the view with the participantIds.
 * This is primarily used by BuzzCheckBookings
 *
 * @param  array $data array of data from the CheckBooking api response
 * @return array
 * @see  BuzzCheckBookings::CheckBookingsController
 */
	public function check($data) {
		$data = $this->_assignBookingIds($data);
		$bookingRefs = array_keys($data);

		$Participant = ClassRegistry::init('BuzzWaivers.Participant');

		$participants = $Participant->find('all', array(
			'conditions' => array(
				'sales_ref' => $bookingRefs
			)
		));
		$bookings = Hash::combine(
			$participants,
			'{n}.Participant.id',
			'{n}.Participant.waiver_complete',
			'{n}.Participant.api_booking_ref'
		);

		$participantIds = [];
		if (! empty($participants)) {
			foreach ($participants as $participant) {
				$apiBookingRef = $participant['Participant']['api_booking_ref'];
				$participantIds[$apiBookingRef] = $participant['Participant']['id'];
			}
		}

		$this->_controller->set('participants', $participantIds);
		$this->_controller->set('showWaivers', true);

		return $data;
	}

/**
 * Assign the booking IDs from the API to the booking data
 * @param array $data Booking data
 * @return array Booking data with booking IDs included
 */
	protected function _assignBookingIds($data) {
		$this->_controller->loadModel('BuzzWaivers.WaiversApi');
		foreach ($data as $salesRef => &$bookings) {
			$dates = [];
			foreach ($bookings as $booking) {
				$dates[] = $this->_controller->WaiversApi->dateToSqlFormat($booking['date']);
			}
			$dates = array_unique($dates);
			foreach ($dates as $date) {
				$results = $this->_controller->WaiversApi->getBooking($salesRef, $date);
				foreach ($results as $result) {
					$key = $this->_findArrayKey($bookings, [
						'date' => $result['date'],
						'description' => $result['description']
					]);
					if ($bookings[$key]['description'] === $result['description']) {
						$bookings[$key]['api_booking_ref'] = $result['reference'];
					}
				}
			}
		}

		return $data;
	}

/**
 * Search an array for a key based on the passed conditions
 * @param array $array Array to search
 * @param array $conditions Search conditions
 * @return string|int Array key
 */
	protected function _findArrayKey($array, $conditions = []) {
		foreach ($array as $key => $row) {
			$found = true;
			foreach ($conditions as $conditionKey => $conditionValue) {
				if ($row[$conditionKey] !== $conditionValue) {
					$found = false;
					continue;
				}
			}

			if ($found === true) {
				return $key;
			}
		}

		return false;
	}

/**
 * Set controller method so that the component's controller can be overriden.
 * @param Controller $controller Controller
 * @return Controller
 */
	public function setController($controller) {
		return $this->_controller = $controller;
	}

}
