<?php
App::uses('AppController', 'Controller');
App::uses('RouterUtil', 'Routable.Lib');

class BuzzWaiversAppController extends AppController {

	public $routable;

	public $kiosk = false;

	public function __construct($request = null, $response = null) {
		$this->routable = new RouterUtil();

		parent::__construct($request, $response);

		$this->__setMode();
		$this->set('kiosk', $this->kiosk);
	}

/**
 * Sets the layout mode for kiosk use
 *
 * @return void
 */
	private function __setMode() {
		if ($this->__isKiosk()) {
			$this->layout = 'BuzzWaivers.Kiosk';
		}
		return;
	}

/**
 * Checks if we need to be in kiosk mode based on the uri path.
 *
 * @return boolean
 */
	private function __isKiosk() {
		// This feels wrong but cakes being a pain and refusing to allow a prefix
		// Thier docs on the subject are either wrong, or for an older version.
		// Seems senseless to waste time working around this for such a small usecase.
		if (strstr($this->request->here, 'kiosk/')) {
			$this->kiosk = true;
			return true;
		}
		$this->kiosk = false;
		return false;
	}

}
