<?php

/**
 * Online waiver routes
 */
Router::connect(
	'/waivers/complete-booking/*',
	['plugin' => 'buzz_waivers', 'controller' => 'waivers', 'action' => 'complete_booking']
);

Router::connect(
	'/waivers/participants/*',
	['plugin' => 'buzz_waivers', 'controller' => 'waivers', 'action' => 'participants']
);

Router::connect(
	'/waivers/participant/*',
	['plugin' => 'buzz_waivers', 'controller' => 'waivers', 'action' => 'participant']
);

Router::connect(
	'/waivers/start/*',
	['plugin' => 'buzz_waivers', 'controller' => 'waivers', 'action' => 'create_waivers']
);

Router::connect(
	'/waivers/stage/*',
	['plugin' => 'buzz_waivers', 'controller' => 'waivers', 'action' => 'stage']
);

Router::connect(
	'/waivers/:action',
	['plugin' => 'buzz_waivers', 'controller' => 'waivers']
);


/**
 * Kiosk mode waiver routes - these use controller based prefix detection as cake
 * doesnt allow us to add extra system prefixes by the time these are loaded, so
 * will 404 if you add a prefix var here.
 */
Router::connect('/:kiosk/', array(':kiosk'), array('pass' => 'kiosk'));

Router::connect(
	'/:kiosk/waivers/complete-booking/*',
	['plugin' => 'buzz_waivers', 'controller' => 'waivers', 'action' => 'complete_booking']
);

Router::connect(
	'/:kiosk/waivers/participants/*',
	['plugin' => 'buzz_waivers', 'controller' => 'waivers', 'action' => 'participants']
);

Router::connect(
	'/:kiosk/waivers/participant/*',
	['plugin' => 'buzz_waivers', 'controller' => 'waivers', 'action' => 'participant']
);

Router::connect(
	'/:kiosk/waivers/start/*',
	['plugin' => 'buzz_waivers', 'controller' => 'waivers', 'action' => 'create_waivers']
);

Router::connect(
 	'/:kiosk/waivers/stage/*',
 	['plugin' => 'buzz_waivers', 'controller' => 'waivers', 'action' => 'stage']
);

Router::connect(
 	'/:kiosk/waivers/:action',
 	['plugin' => 'buzz_waivers', 'controller' => 'waivers']
);
