<?php

$config = array(
	'BuzzWaivers' => array(
		'showOnBookingConfirmation' => true,
		'showOnCheckBooking' => true,

		// What browser compatability checks do we want to perform?
		'checkBrowserWebcamCompatability' => true,
		'checkBrowserCanvasCompatability' => true,

		'stageProcess' => 'default',

		'stages' => array(
			'default' => array(
				'terms' => array(
					'pre' => array(
						'loadTerms'
					),
					'post' => array(),
					'template' => 'Waivers/terms'
				),
				'conditions' => array(
					'pre' => array(
						'loadConditions'
					),
					'post' => array(
						'processConditions',
					),
					'template' => 'Waivers/conditions'
				),
				'signature' => array(
					'pre' => array(),
					'post' => array(
						'processSignature'
					),
					'template' => 'Waivers/signature'
				),
				'photo' => array(
					'pre' => array(),
					'post' => array(
						'processPhoto'
					),
					'template' => 'Waivers/photo'
				),
				'complete' => array(
					'pre' => array('processComplete'),
					'post' => array(),
					'template' => 'Waivers/complete'
				)
			),
			'kiosk' => array(
				'terms' => array(
					'pre' => array(
						'loadTerms'
					),
					'post' => array(),
					'template' => 'Waivers/terms'
				),
				'conditions' => array(
					'pre' => array(
						'loadConditions'
					),
					'post' => array(
						'processConditions',
					),
					'template' => 'Waivers/conditions'
				),
				'signature' => array(
					'pre' => array(),
					'post' => array(
						'processSignature'
					),
					'template' => 'Waivers/signature'
				),
				'photo' => array(
					'pre' => array(),
					'post' => array(
						'processPhoto'
					),
					'template' => 'Waivers/photo'
				),
				'complete' => array(
					'pre' => array('processComplete'),
					'post' => array(),
					'template' => 'Waivers/complete'
				)
			),

		),

		/**
		 * routes for use within the templates incase any overriding takes place
		 */
		'route' => array(
			'Waivers' => array(
				'controller' => 'buzz_waivers.waivers',
				'action' => 'participant',
				'plugin' => 'BuzzWaivers'
			)
		),

	)
);
