<?php
class BuzzWaiversAddEmail extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzWaivers_add_email';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		$EmailGroup = ClassRegistry::init('BuzzEmails.EmailGroup');
		$Email = ClassRegistry::init('BuzzEmails.Email');
		if ($direction === 'up') {
			$EmailGroup->save(['name' => 'Waivers']);
			$Email->save([
				'name' => 'Waiver Notice',
				'system_name' => 'BuzzWaivers.waiver_notice',
				'email_group_id' => $EmailGroup->id,
				'subject' => 'Please complete your waiver',
				'content' => '<p>Hi {firstName},</p><p>Your upcoming&nbsp;booking with us on {date} at {time} requires that you complete a waiver.&nbsp;We recommend you do this in advance of arriving to speed up your checkin process.</p><p>Please follow the link below to complete your waiver.</p><p>{waiverLink}</p><p><strong>Your booking details:</strong></p><p>Your Sales Reference Number is: {salesRef}</p><p>Your checkin time is: {checkin}.</p><p>{==details==}</p>',
				'required_tokens' => '["salesRef","date","time","checkin","waiverLink", "==details=="]',
				'optional_tokens' => '["firstName","lastName","waiverLink","bookedItem","bookingDate"]'
			]);
		} else {
			$waiversGroup = $EmailGroup->findByName('Waivers');
			if (! empty($waiversGroup)) {
				$Email->deleteAll(['email_group_id' => $waiversGroup['EmailGroup']['id']]);
				$EmailGroup->delete($waiversGroup['EmailGroup']['id']);
			}
		}

		return true;
	}
}
