(function(buzz, $, undefined) {
	buzz.vouchers = {};

	var plugin;
	var settings = {
		voucherListing: '[data-voucher]',
		quantityField: '[data-voucher-quantity]',
		buyNowButton: '[data-voucher-buy-now]'
	};

	buzz.vouchers.init = function() {
		plugin = this;

		//call other functions
		plugin.toggleBuyNow();
	}

	buzz.vouchers.toggleBuyNow = function() {
		$(settings.quantityField).on('change', function() {
			var $button = $(this).closest(settings.voucherListing).find(settings.buyNowButton);
			if ($(this).val() > 0) {
				$button.removeClass('hidden');
			} else {
				$button.addClass('hidden');
			}
		});
		$(settings.quantityField).trigger('change');
	}

}(window.buzz = window.buzz || {}, jQuery));

// optional initialisation
buzz.vouchers.init();
