<?php
$this->extend('/Common/2col');
if (!empty($data['VoucherActivity']['page_title'])):
	$this->assign('title', $this->I18n->translate($data, 'VoucherActivity.page_title'));
else:
	$this->assign('title', $this->I18n->translate($data, 'VoucherActivity.name'));
endif;
echo $this->Html->script(['BuzzVouchers.buzz_vouchers.min'], ['inline' => false]);
$this->start('side');
?>

<div class="basket" data-items="<?php echo !empty($basket['GiftVoucherPurchaseItem']) ? count($basket['GiftVoucherPurchaseItem']) : 0; ?>"></div>

	<?php
		echo $this->Fa->link('chevron-circle-left fa-inline', __d('buzz_vouchers', 'Back to Vouchers'), ['action' => 'index'], ['class' => 'button button--fill button--back-to', 'before' => true, 'space' => false]);
	?>

	<div class="content__spacer"></div>

	<?php
		$adverts = count($data['Advert']);
		$i = 0;
		foreach ($data['Advert'] as $advert):
			echo $this->Advert->render($advert);
			++$i;
			echo $i < $adverts ? '<div class="content__spacer"></div>' : null;
		endforeach;
	?>
<?php $this->end(); // side ?>

<?php $this->start('foot'); ?>
	<?php echo $this->element('BuzzVouchers.related_vouchers'); ?>
<?php $this->end(); // foot ?>

<?php if (!empty($data['Image'][0])): ?>
	<div class="text-center">
		<?php echo $this->Img->resize($data['Image'][0], ['width' => 870], ['class' => 'full']); ?>
	</div>
	<div class="content__spacer"></div>
<?php endif; ?>

<div class="content__intro">
	<?php echo $this->I18n->translate($data, 'VoucherActivity.content'); ?>
</div>
<?php if (!empty($data['VoucherActivity']['secondary_content'])): ?>
	<div class="toggle__content">
		<?php echo $this->I18n->translate($data, 'VoucherActivity.secondary_content'); ?>
	</div>
	<p class="toggle"><?php echo __d('buzz_bookings', 'Read More'); ?><i class="fa fa-chevron-circle-down fa-inline"></i></p>
<?php endif; ?>

<?php if (!empty($gallery) || !empty($data['VoucherActivity']['video_url'])): ?>
	<div class="row">
		<?php
			if (!empty($gallery)):
				$class = !empty($data['VoucherActivity']['video_url']) ? 'col-md-6' : 'col-md-12';
		?>
			<div class="col-xs-12 <?php echo $class; ?>">
				<?php echo $this->element('BuzzGallery.mini_gallery', ['data' => $gallery['GalleryImage']]); ?>

				<div class="content__spacer"></div>
			</div>
		<?php endif; ?>

		<?php
			if (!empty($data['VoucherActivity']['video_url'])):
				$class = !empty($gallery) ? 'col-md-6' : 'col-md-12';
		?>
			<div class="col-xs-12 <?php echo $class; ?>">
				<div class="aspect aspect--16_9">
					<!-- force iframe to full width 16:9 ratio with css -->
					<?php echo $this->Video->embed($data['VoucherActivity']['video_url'], ['width' => '100%', 'height' => '100%']); ?>
				</div>
				<div class="content__spacer"></div>
			</div>
		<?php endif; ?>
	</div>
<?php endif; ?>

<div class="row">
	<div class="col-xs-12">
		<div class="content__spacer"></div>

		<?php $tabs = count($data['Tab']) + (int)!empty($data['GiftVoucher']); ?>

		<?php if ($tabs > 1): ?>

			<div class="responsivetabs">
				<ul>
					<?php if (!empty($data['GiftVoucher'])): ?>
						<li><?php echo $this->Html->link(__d('buzz_vouchers', 'Vouchers'), '#tab-0'); ?></li>
					<?php endif; ?>
					<?php $i = 0; ?>
					<?php foreach ($data['Tab'] as $tab): ?>
						<?php ++$i; ?>
						<li><?php echo $this->Html->link($this->I18n->translate($tab, 'title'), '#tab-' . $i); ?></li>
					<?php endforeach; ?>
				</ul>
				<?php if (!empty($data['GiftVoucher'])): ?>
					<div id="tab-0">
						<?php echo $this->Form->create(); ?>
						<?php foreach ($data['GiftVoucher'] as $voucher): ?>

							<?php echo $this->element('BuzzVouchers.Forms/voucher', ['data' => $voucher]); ?>

						<?php endforeach; ?>

						<div class="booking__actions">
							<div class="row">
								<div class="col-xs-6">
									<?php echo $this->Html->link(__d('buzz_vouchers', 'Back'), $previousStep, ['class' => 'button button--light background--septenary left']); ?>
								</div>

								<div class="col-xs-6">
									<?php echo $this->Form->button(__d('buzz_vouchers', 'Proceed'), ['class' => 'button button--dark background--senary right']); ?>
								</div>
							</div>
						</div>
						<?php echo $this->Form->end(); ?>
					</div>
				<?php endif; ?>
				<?php $i = 0; ?>
				<?php foreach ($data['Tab'] as $tab): ?>
					<?php ++$i; ?>
					<div id="tab-<?php echo $i; ?>">
						<?php echo !empty($tab['Image'][0]) ? $this->Img->resize($tab['Image'][0], ['width' => 870], ['class' => 'center full']) . '<br />' : null; ?>
						<?php echo $this->I18n->translate($tab, 'content'); ?>
					</div>
				<?php endforeach; ?>
			</div>

		<?php else: ?>

			<?php if (!empty($data['GiftVoucher'])): ?>
				<h2><?php echo __d('buzz_vouchers', 'Vouchers'); ?></h2>
				<?php echo $this->Form->create(); ?>
				<?php foreach ($data['GiftVoucher'] as $voucher): ?>

					<?php echo $this->element('BuzzVouchers.Forms/voucher', ['data' => $voucher]); ?>

				<?php endforeach; ?>
				<div class="booking__actions">
					<div class="row">
						<div class="col-xs-6">
							<?php echo $this->Html->link(__d('buzz_vouchers', 'Back'), $previousStep, ['class' => 'button button--light background--septenary left']); ?>
						</div>

						<div class="col-xs-6">
							<?php echo $this->Form->button(__d('buzz_vouchers', 'Proceed'), ['class' => 'button button--dark background--senary right button--booking-proceed']); ?>
						</div>
					</div>
				</div>
				<?php echo $this->Form->end(); ?>
			<?php else: ?>
				<h2><?php echo $this->I18n->translate($data, 'Tab.0.title'); ?></h2>
				<?php echo !empty($data['Tab'][0]['Image'][0]) ? $this->Img->resize($data['Tab'][0]['Image'][0], ['width' => 870], ['class' => 'center full']) . '<br />' : null; ?>
				<?php echo $this->I18n->translate($data, 'Tab.0.content'); ?>
			<?php endif; ?>

		<?php endif; ?>

	</div>
</div>


