<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_vouchers', 'Voucher Step %d', [4]));
?>

<?php echo $this->element('BuzzVouchers.voucher_basket', ['basket' => $basket]); ?>

<?php echo $this->Form->create(null, ['class' => 'validate']); ?>

<div class="row">
	<div class="col-xs-12">
		<?php if ($basket['GiftVoucherPurchase']['total_cost'] > 0): ?>
			<h2><?php echo __d('buzz_vouchers', 'Please enter your billing and payment details'); ?></h2>
		<?php else: ?>
			<h2><?php echo __d('buzz_vouchers', 'Please enter your contact details'); ?></h2>
		<?php endif; ?>
	</div>
</div>

<div class="row">
	<div class="col-xs-12 col-md-6">
		<?php if ($basket['GiftVoucherPurchase']['total_cost'] > 0): ?>
			<h3><?php echo __d('buzz_vouchers', 'Billing details'); ?></h3>
		<?php else: ?>
			<h3><?php echo __d('buzz_vouchers', 'Contact details'); ?></h3>
		<?php endif; ?>
		<div class="form--side-labels form--compact validate">
			<?php if (empty($basket['GiftVoucherDeliveryOption']['online'])): ?>
				<div class="input checkbox checkbox--custom checkbox--left clear">
					<?= $this->Form->checkbox('use_delivery_address') ?>
					<?= $this->Form->label('use_delivery_address', __d('buzz_vouchers', 'Same as delivery address')) ?>
				</div>
			<?php endif; ?>
			<?php echo $this->Element('BuzzCustomers.address_form'); ?>
			<?php if (empty($basket['GiftVoucherDeliveryOption']['online'])): ?>
				<div class="input hidden js-billing-address">
					<label>Billing Address</label>
					<?= $this->Address->format($basket['DeliveryAddress']) ?>
				</div>
			<?php endif ?>
			<?php echo $this->Form->input('CustomerAddress.telephone', ['label' => __d('buzz_vouchers', 'Telephone')]); ?>
			<?php echo $this->Form->input('CustomerAddress.email', ['label' => __d('buzz_vouchers', 'Email')]); ?>
		</div>
	</div>
	<div class="col-xs-12 col-md-6">
		<?php if (Configure::read('BuzzPurchase.onsite') === true && $basket['GiftVoucherPurchase']['total_cost'] > 0): ?>
			<h3><?php echo __d('buzz_vouchers', 'Payment details'); ?></h3>
			<div class="form--side-labels form--compact validate">
				<?php echo $this->element('BuzzPurchase.Forms/payment_form'); ?>
			</div>
			<div class="content__spacer">&nbsp;</div>
		<?php endif; ?>

		<?php foreach ($conditions as $condition): ?>
			<div class="input checkbox checkbox--custom checkbox--left clear">
				<?php echo $this->Form->checkbox('condition.' . $condition['Condition']['id'], ['class' => 'required']); ?>
				<?php echo $this->Form->label('condition.' . $condition['Condition']['id'], $this->I18n->translate($condition, 'Condition.rendered_content')); ?>
			</div>
		<?php endforeach; ?>

		<?php if (Configure::read('BuzzVouchers.show_newsletter_opt_in') === true): ?>
			<div class="input checkbox checkbox--custom checkbox--left clear">
				<?= $this->Form->checkbox('GiftVoucherPurchase.newsletter_opt_in') ?>
				<?= $this->Form->label('GiftVoucherPurchase.newsletter_opt_in', __d('buzz_vouchers', 'Signup to Exclusive Offers & News')) ?>
			</div>
		<?php endif; ?>
	</div>
</div>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-6">
			<?php echo $this->Html->link(__d('buzz_vouchers', 'Back'), $previousStep, ['class' => 'button button--light background--septenary left']); ?>
		</div>

		<div class="col-xs-6">
			<?php if ($basket['GiftVoucherPurchase']['total_cost'] > 0): ?>
				<?php echo $this->Form->button(__d('buzz_vouchers', 'Pay Now') . '<i class="fa fa-credit-card fa-inline"></i>', ['class' => 'button button--dark background--senary right button--booking-proceed']); ?>
			<?php else: ?>
				<?php echo $this->Form->button(__d('buzz_vouchers', 'Complete'), ['class' => 'button button--dark background--senary right']); ?>
			<?php endif; ?>
		</div>
	</div>
</div>

<?php echo $this->Form->end(); ?>
