<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_vouchers', 'Voucher Step %d', [2]));
?>

<?php echo $this->Form->create(null, ['class' => 'validate']); ?>

<div class="content__spacer"></div>

<?php echo $this->element('BuzzVouchers.voucher_basket', ['basket' => $basket, 'edit' => true]); ?>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-12">
			<h3><?php echo __d('buzz_vouchers', 'Confirm and complete your order'); ?></h3>
			<div class="content__spacer">&nbsp;</div>
		</div>
	</div>
	<div class="row text-center">
		<div class="col-xs-12 col-sm-6 col-sm-push-3 col-md-4 col-md-push-4">
			<?php
				echo $this->Html->link(
					__d('buzz_vouchers', 'I am ready to check out'),
					['action' => 'delivery'],
					['class' => 'button booking__checkout button--booking-proceed']
				);
			?>
		</div>
		<div class="content__spacer"></div>
	</div>
</div>

<?php $totalListedActivites = count($voucherActivities); ?>
<h3><?= __d('buzz_vouchers', 'Buy additional vouchers') ?></h3>
<div class="row n-items gallery" data-n-items="<?php echo $totalListedActivites; ?>" data-gallery-breakpoints="[1,3,6,6]" style="display:none">
	<?php foreach ($voucherActivities as $activity): ?>
		<div class="n-items__item">
			<a class="category category--border<?php
				if (!empty($activity['VoucherActivity']['theme_id'])) {
					echo " theme--".$activity['VoucherActivity']['theme_id'];
				}
			?>" href="<?php echo $this->Html->url(['action' => 'vouchers', $activity['VoucherActivity']['id']]); ?>">
				<?php
					$img = (empty($activity['ListingImage'][0])) ? 'no-image.png' : $activity['ListingImage'][0];
					$imgHeight = 250;
					$imgWidth = 360;
					if ($totalListedActivites === 3) {
						$imgHeight = 200;
						$imgWidth = 370;
					}
					if ($totalListedActivites < 3) {
						$imgHeight = 150;
						$imgWidth = 570;
					}
					echo $this->Img->resize($img, ['width' => $imgWidth, 'height' => $imgHeight, 'crop' => true]);
				?>
				<div class="category__content js-match-heights-simple vertical-center">
					<div>
						<h3><?php echo $this->I18n->translate($activity, 'VoucherActivity.name'); ?><i class="fa fa-chevron-circle-right fa-inline"></i></h3>
					</div>
				</div>
			</a>
			<div class="content__spacer"></div>
		</div>
	<?php endforeach; ?>
</div>

<div class="row">
	<div class="col-xs-6">
		<?php echo $this->Html->link(__d('buzz_vouchers', 'Back'), $previousStep, ['class' => 'button button--light background--septenary left']); ?>
	</div>
</div>

<?php echo $this->Form->end(); ?>
