<?php $this->Extend('/Scaffolds/admin_form'); ?>
<?php $this->Append('additionalFormTabs'); ?>

	<?php
		if (!empty($this->request->data['GiftVoucherPurchase']['completed_date'])):
			echo $this->Html->tag('div', $this->element('admin_purchase_details'), ['class' => 'tab__content', 'data-title' => __d('buzz_vouchers', 'Details')]);
		endif;
	?>

	<?php
		if (
			!empty($purchase['GiftVoucherPurchase']['api_log'])
			&& (int)$authUser['UserGroup']['id'] === 1
		):
			echo $this->Html->tag(
				'div',
				'<pre>' .  print_r(json_decode($purchase['GiftVoucherPurchase']['api_log']), 1) . '</pre>',
				['class' => 'tab__content', 'data-title' => __d('buzz_vouchers', 'API Errors')]
			);
		endif;
		if (!empty($apiCalls)):
		?>
			<div class="tab__content" data-title="<?=__d('buzz_bookings', 'API Calls')?>">
				<?=$this->element('BuzzSource.api_log')?>
				<?php if (! empty($itemApiCalls)): ?>
					<hr />
					<h4>Voucher Item API Calls</h4>
					<?=$this->element('BuzzSource.api_log', array('apiCalls' => $itemApiCalls))?>
				<?php endif; ?>

			</div>

		<?php
		endif;
	?>

<?php $this->end(); // additionalFormTabs end ?>

<?php

	echo $this->Form->addField('GiftVoucherPurchase.id', array(
		'type' => 'hidden'
	));

	echo $this->Form->addField(
		'GiftVoucherPurchase.sales_ref',
		array(
			'type' => 'string',
			'label' => __d('buzz_vouchers', 'Sales Ref'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'GiftVoucherPurchase.gift_voucher_purchase_state_id',
		array(
			'type' => 'select',
			'label' => __d('buzz_vouchers', 'Status'),
			'empty' => false,
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'GiftVoucherPurchase.completed_date',
		array(
			'type' => 'date',
			'label' => __d('buzz_vouchers', 'Completed Date'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'GiftVoucherPurchase.gift_voucher_delivery_option_id',
		array(
			'type' => 'string',
			'label' => __d('buzz_vouchers', 'Delivery Option'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'CustomerAddress.full_name',
		array(
			'type' => 'string',
			'label' => __d('buzz_vouchers', 'Customer'),
			'displayonly' => true
		)
	);

	echo $this->Form->input('CustomerAddress.id');

	echo $this->Form->addField(
		'CustomerAddress.email',
		array(
			'type' => 'email',
			'label' => __d('buzz_vouchers', 'Email Address')
		)
	);

	echo $this->Form->addField(
		'CustomerAddress.telephone',
		array(
			'type' => 'tel',
			'label' => __d('buzz_vouchers', 'Telephone')
		)
	);
?>

<div class="field">
	<div class="field__label"><?php echo __d('buzz_vouchers', 'Total Cost'); ?></div>
	<div class="field__value">
		<?php echo $this->Number->currency($purchase['GiftVoucherPurchase']['total_cost']); ?>
	</div>
</div>

<?php if (! empty($this->request->data['transaction']['vendorTxCode'])): ?>
	<div class="field">
		<div class="field__label">Transaction Ref</div>
		<div class="field__value">
			<?= h($purchase['transaction']['vendorTxCode']); ?>
		</div>
	</div>
<?php endif; ?>

<?php if (Configure::read('BuzzVouchers.show_newsletter_opt_in') === true): ?>
	<div class="field">
		<div class="field__label">Newsletter Opt-in</div>
		<div class="field__value">
			<?php if ($purchase['GiftVoucherPurchase']['newsletter_opt_in']): ?>
				<i class="fa fa-check"></i>
			<?php else: ?>
				<i class="fa fa-times"></i>
			<?php endif; ?>
		</div>
	</div>
<?php endif; ?>

