<?php
	$items = Hash::combine($basket['GiftVoucherPurchaseItem'], '{n}.id', '{n}', '{n}.GiftVoucher.voucher_activity_id');
	$activities = Hash::combine($basket['GiftVoucherPurchaseItem'], '{n}.GiftVoucher.VoucherActivity.id', '{n}.GiftVoucher.VoucherActivity');
	$edit = !empty($edit);
?>
<div class="row">
	<div class="col-xs-12">
		<div class="outline--septenary outline--thin background--white padding-gutters-1_2 basket">

			<?php foreach ($items as $activityId => $activityItems): ?>

				<h3><?php echo __d('buzz_vouchers', '%s Gift Vouchers', $this->I18n->translate($activities[$activityId], 'name')); ?></h3>

				<?php foreach ($activityItems as $key => $item): ?>

					<div class="listing listing--booking">
						<div class="row">
							<div class="col-xs-12 col-sm-<?php echo $edit === true ? 5 : 6; ?> xs-extra-gutters-1--left sm-plus-extra-gutters-2--left">
								<h3><?php echo $this->I18n->translate($item, 'GiftVoucher.name'); ?></h3>
							</div>

							<div class="col-xs-3 col-sm-2 xs-text-left xs-extra-gutters-1--left text-right fa--senary">
								<?php if (!empty($item['GiftVoucher']['participants'])): ?>
									<?php if ($item['GiftVoucher']['participants'] < 5): ?>
										<?php for ($i = 0; $i < $item['GiftVoucher']['participants']; $i++): ?>
											<i class="fa fa-user"></i>
										<?php endfor; ?>
									<?php else: ?>
										<i class="fa fa-users"></i>
									<?php endif; ?>
									<strong><?php echo $item['GiftVoucher']['participants']; ?></strong>
								<?php endif; ?>
							</div>

							<div class="col-xs-3 col-sm-2 gutterless text-center">
								<?php if ($edit === true): ?>
									<?php
										echo $this->Form->input(
											'GiftVoucherPurchaseItem.' . $key . '.id',
											['value' => $item['id']]
										);
										echo $this->Form->input(
											'GiftVoucherPurchaseItem.' . $key . '.quantity',
											[
												'div' => 'input input--quantity input--auto-submit',
												'label' => __d('buzz_vouchers', 'Quantity:') . '&nbsp;',
												'type' => 'number',
												'value' => $item['quantity']
											]
										);
									?>
								<?php else: ?>
									<strong><?php echo __d('buzz_vouchers', 'Quantity:') . ' ' . $item['quantity']; ?></strong>
								<?php endif; ?>
							</div>
							<div class="col-xs-4 col-sm-2">
								<strong><?php echo __d('buzz_vouchers', 'Price:'); ?></strong>
								<span class="large"><?php echo $this->Number->price($item['item_unit_cost']) ?></span>
							</div>
							<?php if ($edit === true): ?>
								<div class="col-xs-1 col-sm-1 xs-gutterless--left sm-plus-extra-gutters-2--right text-right">
									<?php echo $this->Fa->link('times-circle', null, ['action' => 'remove', $item['id']], ['class' => 'basket__delete', 'title' => __d('buzz_vouchers', 'Remove')]); ?>
								</div>
							<?php endif; ?>

						</div>
						<?php if (!empty($item['GiftVoucherPurchaseItemVoucher'])): ?>
							<?php foreach ($item['GiftVoucherPurchaseItemVoucher'] as $voucher): ?>
								<div class="row">
									<div class="col-xs-12 col-sm-12 xs-extra-gutters-1 sm-plus-extra-gutters-2">
										<?php
											$code = $this->Html->link(
												$voucher['code'],
												array(
													'plugin' => 'buzz_vouchers',
													'controller' => 'gift_voucher_purchase_item_vouchers',
													'action' => 'evoucher',
													$voucher['id'],
													$basket['GiftVoucherPurchase']['id'],
													$voucher['code']
												),
												array(
													'class' => 'voucher-code'
												)
											);
											echo __d('buzz_vouchers', 'Voucher Code: %s', [$code]);
										?>
										(<?php echo __d('buzz_vouchers', 'expiry date: %s', [$voucher['expiry_date']]); ?>)
									</div>
								</div>
							<?php endforeach; ?>
						<?php endif; ?>
					</div>

				<?php endforeach; ?>

			<?php endforeach; ?>

			<?php if (!empty($basket['GiftVoucherDeliveryOption']['id'])): ?>

				<div class="listing listing--booking">
					<div class="row">
						<div class="col-xs-12 col-sm-<?php echo $edit === true ? 5 : 6; ?> xs-extra-gutters-1--left sm-plus-extra-gutters-2--left">
							<h3><?php echo $this->I18n->translate($basket, 'GiftVoucherDeliveryOption.name'); ?></h3>
						</div>

						<div class="col-xs-3 col-sm-2 xs-text-left xs-extra-gutters-1--left text-right fa--senary">
						</div>

						<div class="col-xs-3 col-sm-2 gutterless text-center">
						</div>
						<div class="col-xs-4 col-sm-2">
							<strong><?php echo __d('buzz_vouchers', 'Price:'); ?></strong>
							<span class="large"><?php echo $this->Number->price($basket['GiftVoucherPurchase']['delivery_cost']); ?></span>
						</div>
						<?php if ($edit === true): ?>
							<div class="col-xs-1 col-sm-1 xs-gutterless--left sm-plus-extra-gutters-2--right text-right">
								<?php echo $this->Fa->link('pencil', null, ['action' => 'delivery'], ['class' => 'basket__delete', 'title' => __d('buzz_vouchers', 'Edit')]); ?>
							</div>
						<?php endif; ?>

					</div>
				</div>

			<?php endif; ?>

			<?php if (! empty($basket['GiftVoucherPurchase']['discount']) && ! empty($basket['GiftVoucherPurchase']['discount_code'])): ?>
				<div class="row">
					<div class="col-xs-12 col-sm-3 basket__total pull-right text-right">
						<strong><?php echo __d('buzz_bookings', 'Sub-Total:'); ?> <span class="large"><?php echo $this->Number->currency(($basket['GiftVoucherPurchase']['discount'] + $basket['GiftVoucherPurchase']['total_cost'])); ?></strong>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 col-sm-6">
						<strong><?php echo __d('buzz_bookings', 'Discount Code:')?></strong>
						<?=$basket['GiftVoucherPurchase']['discount_code']?>
					</div>
					<div class="col-xs-12 col-sm-3 basket__total pull-right text-right">

						<strong><?php echo __d('buzz_bookings', 'Discount:'); ?> <span class="large"><?php echo $this->Number->currency($basket['GiftVoucherPurchase']['discount']); ?></strong>
					</div>
				</div>
			<?php endif; ?>

			<?php
				// Temporary hack to put VAT on Bodyflight baskets until a proper VAT solution is
				// built. This will want removing once we can properly handle VAT across the sites.
			?>
			<?php if (! empty($paid) && Configure::check('BuzzPurchase.taxPercent')): ?>
				<div class="row">
					<div class="col-xs-12 basket__total text-right">
						<strong>
							<?= (Configure::check('BuzzPurchase.taxLabel') ? Configure::read('BuzzPurchase.taxLabel') : __('Tax')) ?> <span>
								<?php
									if (Configure::read('BuzzPurchase.showAmount') && Configure::check('BuzzPurchase.showPercent')) {
										echo "(" . Configure::read('BuzzPurchase.taxPercent') . "%) " . $this->Purchase->tax($basket['GiftVoucherPurchase']['total_cost']);
									} elseif (Configure::read('BuzzPurchase.showAmount')) {
										echo $this->Purchase->tax($basket['GiftVoucherPurchase']['total_cost']);
									} elseif (Configure::check('BuzzPurchase.showPercent')) {
										echo Configure::read('BuzzPurchase.taxPercent') . "%";
									}
								?>
							</span>
						</strong>
					</div>
				</div>
			<?php endif; ?>

			<div class="row">
				<div class="col-xs-12 basket__total text-right">
					<strong><?php echo !empty($paid) ? __d('buzz_vouchers', 'Total Paid:') : __d('buzz_vouchers', 'Total:'); ?> <span class="large"><?php echo $this->Number->currency($basket['GiftVoucherPurchase']['total_cost']); ?></span></strong>
				</div>
			</div>
		</div>

		<div class="content__spacer"></div>
	</div>
</div>

<?php if (! empty($showDiscountForm)): ?>
	<div class="row">
		<div class="col-xs-12">
			<div class="outline--septenary outline--thin background--white padding-gutters-1_2 basket">
				<h3><?php echo __d('buzz_bookings', 'Discount Code'); ?></h3>
				<p>
					<?php echo __d('buzz_bookings', 'If you have a discount code, you may enter it below to apply it to your order.'); ?>
				</p>

				<div class="row">
					<div class="col-xs-12 col-sm-4 col-md-3">
						<?php echo $this->Form->addField('discount_code', array(
							'label' => false,
							'type' => 'string',
							'value' => (! empty($data['Booking']['discount_code']) ? $data['Booking']['discount_code'] : null)
						)); ?>
					</div>
					<div class="col-xs-12 col-sm-4 col-md-3">
						<?php echo $this->Form->button(__d('buzz_bookings', 'Apply Discount'), ['class' => 'button', 'name' => 'apply_discount', 'value' => 1]); ?>
					</div>
				</div>

			</div>
		</div>
	</div>
<?php endif; ?>
