<div class="gw field">

	<div class="g one-half">
		<?php
			echo $this->Html->tag('h3', __d('buzz_vouchers', 'Customer Address'));
			echo $this->Address->format(
				$this->request->data['CustomerAddress'],
				[
					['first_name', 'last_name'],
					'address_line_1',
					'address_line_2',
					'address_line_3',
					'city',
					'postcode',
					'Country.name'
				]
			);
		?>
	</div>

	<div class="g one-half">
		<?php
			echo $this->Html->tag('h3', __d('buzz_vouchers', 'Delivery Address'));
			echo $this->Address->format(
				$this->request->data['DeliveryAddress'],
				[
					['first_name', 'last_name'],
					'address_line_1',
					'address_line_2',
					'address_line_3',
					'city',
					'postcode',
					'Country.name'
				]
			);
		?>
	</div>

</div>
<div class="gw field">

	<div class="g">
		<table class='data-table'>
			<thead>
				<tr>
					<th><?= __d('buzz_vouchers', 'Name'); ?></th>
					<th><?= __d('buzz_vouchers', 'Code'); ?></th>
					<th><?= __d('buzz_vouchers', 'Expiry Date'); ?></th>
					<th><?= __d('buzz_vouchers', 'Total'); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($this->request->data['GiftVoucherPurchaseItem'] as $item): ?>
					<?php foreach ($item['GiftVoucherPurchaseItemVoucher'] as $voucher): ?>
						<tr>
							<td><?= h($item['GiftVoucher']['name']); ?></td>
							<td>
								<?php
									echo $this->Html->link(
										$voucher['code'],
										array(
											'controller' => 'gift_voucher_purchase_item_vouchers',
											'action' => 'evoucher',
											$voucher['id'],
											$this->request->data['GiftVoucherPurchase']['id'],
											$voucher['code'],
											'admin' => false
										)
									);
								?>
							</td>
							<td><?= $voucher['expiry_date']; ?></td>
							<td><?= $this->Number->currency($item['item_unit_cost']); ?></td>
						</tr>
					<?php endforeach; ?>
				<?php endforeach; ?>
				<?php if (! empty($this->request->data['GiftVoucherPurchase']['discount']) && ! empty($this->request->data['GiftVoucherPurchase']['discount_code'])): ?>
					<tr>
						<td colspan="3">Discount: <?= h($this->request->data['GiftVoucherPurchase']['discount_code']) ?></td>
						<td><?= $this->Number->currency($this->request->data['GiftVoucherPurchase']['discount']); ?></td>
					</tr>
				<?php endif; ?>
				<?php if (!empty($this->request->data['GiftVoucherDeliveryOption']['id'])): ?>
					<tr>
						<td colspan="3"><?= h($this->request->data['GiftVoucherDeliveryOption']['name']) ?></td>
						<td><?= $this->Number->currency($this->request->data['GiftVoucherPurchase']['delivery_cost']); ?></td>
					</tr>
				<?php endif; ?>
			</tbody>
			<tfoot>
				<tr>
					<th colspan="3" class="text--right"><?= __d('buzz_vouchers', 'Total Cost'); ?></th>
					<th><?= $this->Number->currency($this->request->data['GiftVoucherPurchase']['total_cost']); ?></th>
				</tr>
			</tfoot>
		</table>
	</div>

</div>
