<?php

class VoucherApiTest extends CakeTestCase {

	public function setUp() {
		parent::setUp();
		$this->VoucherApi = ClassRegistry::init('BuzzVouchers.VoucherApi');
		// We're not directly testing the API as the test data isn't reliable
		// so we want to switch the DB config for test to avoid errors.
		$this->VoucherApi->useDbConfig = 'test';
	}

/**
 * Make protected methods accessible for testing
 *
 * @param string $name Method name
 * @return object
 */
	public static function getMethod($name) {
		$VoucherApi = new ReflectionClass('VoucherApi');
		$method = $VoucherApi->getMethod($name);
		$method->setAccessible(true);
		return $method;
	}

	public function testProcessVouchers() {
		// Get sample voucher data
		$data = $this->_apiVoucherResponse();

		$processVouchers = self::getMethod('_processVouchers');
		$result = $processVouchers->invokeArgs($this->VoucherApi, [$data['VoucherApi']['d']]);
		$this->assertInternalType('array', $result);

		return;
	}

/**
 * Sample data from API for testing
 *
 * @return array
 */
	protected function _apiVoucherResponse() {
		return array(
			'VoucherApi' => array(
				'd' => array(
					array(
						'__type' => 'VoucherData:#BookingSystem.BookingEngine',
						'Description' => 'Fly With A Friend',
						'ExpiryDate' => '01/06/2016',
						'Id' => '1000',
						'VoucherNo' => '1000',
						'SalesOrderId' => 1234
					),
					array(
						'__type' => 'VoucherData:#BookingSystem.BookingEngine',
						'Description' => 'Fly With A Friend',
						'ExpiryDate' => '01/06/2016',
						'Id' => '1001',
						'VoucherNo' => '2000',
						'SalesOrderId' => 1234
					)
				)
			)
		);
	}

}
