<?php

class VoucherActivityTest extends CakeTestCase {

	public $fixtures = array(
		'plugin.buzz_vouchers.VoucherActivity',
		'plugin.buzz_vouchers.GiftVoucher',
		'plugin.buzz_translate.Translation',
		'plugin.ev_core.Image',
	);

	public function setUp() {
		parent::setUp();
		$this->VoucherActivity = ClassRegistry::init('BuzzVouchers.VoucherActivity');
	}

	public function testGetListed() {
		$result = $this->VoucherActivity->getListed();
		$this->assertCount(2, $result);
		return;
	}

	public function testOnlyAvailableActivity() {
		$result = $this->VoucherActivity->onlyAvailableActivity();
		$this->assertFalse($result);
		return;
	}

	public function testGetPurchasableVoucherActivity() {
		$result = $this->VoucherActivity->getPurchasableVoucherActivity(1);
		$this->assertInternalType('array', $result);

		$result = $this->VoucherActivity->getPurchasableVoucherActivity(2);
		$this->assertFalse($result);

		return;
	}

	public function testGetPurchasableVoucherActivitySequence() {
		// Test that the vouchers are returned in the expected sequence.
		$result = $this->VoucherActivity->getPurchasableVoucherActivity(1);
		$expected = [2, 1];
		$this->assertEquals($expected, Hash::extract($result, 'GiftVoucher.{n}.id'));

		return;
	}

}
